package zio.aws.workspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.workspaces.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class Snapshot(snapshotTime: Optional[Timestamp] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.Snapshot = {
    import Snapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.Snapshot
      .builder()
      .optionallyWith(
        snapshotTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.snapshotTime)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.Snapshot.ReadOnly =
    zio.aws.workspaces.model.Snapshot.wrap(buildAwsValue())
}
object Snapshot {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.Snapshot
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.Snapshot =
      zio.aws.workspaces.model.Snapshot(snapshotTime.map(value => value))
    def snapshotTime: Optional[Timestamp]
    def getSnapshotTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("snapshotTime", snapshotTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.Snapshot
  ) extends zio.aws.workspaces.model.Snapshot.ReadOnly {
    override val snapshotTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotTime())
      .map(value => zio.aws.workspaces.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.Snapshot
  ): zio.aws.workspaces.model.Snapshot.ReadOnly = new Wrapper(impl)
}
