package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{NonEmptyString, SamlUserAccessUrl}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SamlProperties(
    status: Optional[zio.aws.workspaces.model.SamlStatusEnum] = Optional.Absent,
    userAccessUrl: Optional[SamlUserAccessUrl] = Optional.Absent,
    relayStateParameterName: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.SamlProperties = {
    import SamlProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.SamlProperties
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        userAccessUrl.map(value =>
          SamlUserAccessUrl.unwrap(value): java.lang.String
        )
      )(_.userAccessUrl)
      .optionallyWith(
        relayStateParameterName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.relayStateParameterName)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.SamlProperties.ReadOnly =
    zio.aws.workspaces.model.SamlProperties.wrap(buildAwsValue())
}
object SamlProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.SamlProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.SamlProperties =
      zio.aws.workspaces.model.SamlProperties(
        status.map(value => value),
        userAccessUrl.map(value => value),
        relayStateParameterName.map(value => value)
      )
    def status: Optional[zio.aws.workspaces.model.SamlStatusEnum]
    def userAccessUrl: Optional[SamlUserAccessUrl]
    def relayStateParameterName: Optional[NonEmptyString]
    def getStatus: ZIO[Any, AwsError, zio.aws.workspaces.model.SamlStatusEnum] =
      AwsError.unwrapOptionField("status", status)
    def getUserAccessUrl: ZIO[Any, AwsError, SamlUserAccessUrl] =
      AwsError.unwrapOptionField("userAccessUrl", userAccessUrl)
    def getRelayStateParameterName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "relayStateParameterName",
        relayStateParameterName
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.SamlProperties
  ) extends zio.aws.workspaces.model.SamlProperties.ReadOnly {
    override val status: Optional[zio.aws.workspaces.model.SamlStatusEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.workspaces.model.SamlStatusEnum.wrap(value))
    override val userAccessUrl: Optional[SamlUserAccessUrl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userAccessUrl())
        .map(value =>
          zio.aws.workspaces.model.primitives.SamlUserAccessUrl(value)
        )
    override val relayStateParameterName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relayStateParameterName())
        .map(value => zio.aws.workspaces.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.SamlProperties
  ): zio.aws.workspaces.model.SamlProperties.ReadOnly = new Wrapper(impl)
}
