package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{Region, WorkspaceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RelatedWorkspaceProperties(
    workspaceId: Optional[WorkspaceId] = Optional.Absent,
    region: Optional[Region] = Optional.Absent,
    state: Optional[zio.aws.workspaces.model.WorkspaceState] = Optional.Absent,
    `type`: Optional[
      zio.aws.workspaces.model.StandbyWorkspaceRelationshipType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.RelatedWorkspaceProperties = {
    import RelatedWorkspaceProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.RelatedWorkspaceProperties
      .builder()
      .optionallyWith(
        workspaceId.map(value => WorkspaceId.unwrap(value): java.lang.String)
      )(_.workspaceId)
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.RelatedWorkspaceProperties.ReadOnly =
    zio.aws.workspaces.model.RelatedWorkspaceProperties.wrap(buildAwsValue())
}
object RelatedWorkspaceProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.RelatedWorkspaceProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.RelatedWorkspaceProperties =
      zio.aws.workspaces.model.RelatedWorkspaceProperties(
        workspaceId.map(value => value),
        region.map(value => value),
        state.map(value => value),
        `type`.map(value => value)
      )
    def workspaceId: Optional[WorkspaceId]
    def region: Optional[Region]
    def state: Optional[zio.aws.workspaces.model.WorkspaceState]
    def `type`
        : Optional[zio.aws.workspaces.model.StandbyWorkspaceRelationshipType]
    def getWorkspaceId: ZIO[Any, AwsError, WorkspaceId] =
      AwsError.unwrapOptionField("workspaceId", workspaceId)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
    def getState: ZIO[Any, AwsError, zio.aws.workspaces.model.WorkspaceState] =
      AwsError.unwrapOptionField("state", state)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.StandbyWorkspaceRelationshipType
    ] = AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.RelatedWorkspaceProperties
  ) extends zio.aws.workspaces.model.RelatedWorkspaceProperties.ReadOnly {
    override val workspaceId: Optional[WorkspaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.workspaceId())
      .map(value => zio.aws.workspaces.model.primitives.WorkspaceId(value))
    override val region: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.workspaces.model.primitives.Region(value))
    override val state: Optional[zio.aws.workspaces.model.WorkspaceState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.workspaces.model.WorkspaceState.wrap(value))
    override val `type`
        : Optional[zio.aws.workspaces.model.StandbyWorkspaceRelationshipType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.workspaces.model.StandbyWorkspaceRelationshipType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.RelatedWorkspaceProperties
  ): zio.aws.workspaces.model.RelatedWorkspaceProperties.ReadOnly = new Wrapper(
    impl
  )
}
