package zio.aws.workspaces.model
import scala.jdk.CollectionConverters.*
sealed trait Protocol {
  def unwrap: software.amazon.awssdk.services.workspaces.model.Protocol
}
object Protocol {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.Protocol
  ): zio.aws.workspaces.model.Protocol = value match {
    case software.amazon.awssdk.services.workspaces.model.Protocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.Protocol.PCOIP =>
      val r = PCOIP
      r
    case software.amazon.awssdk.services.workspaces.model.Protocol.WSP =>
      val r = WSP
      r
  }
  case object unknownToSdkVersion extends zio.aws.workspaces.model.Protocol {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.Protocol =
      software.amazon.awssdk.services.workspaces.model.Protocol.UNKNOWN_TO_SDK_VERSION
  }
  case object PCOIP extends zio.aws.workspaces.model.Protocol {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.Protocol =
      software.amazon.awssdk.services.workspaces.model.Protocol.PCOIP
  }
  case object WSP extends zio.aws.workspaces.model.Protocol {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.Protocol =
      software.amazon.awssdk.services.workspaces.model.Protocol.WSP
  }
}
