package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{WorkspaceId, DirectoryId, UserName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PendingCreateStandbyWorkspacesRequest(
    userName: Optional[UserName] = Optional.Absent,
    directoryId: Optional[DirectoryId] = Optional.Absent,
    state: Optional[zio.aws.workspaces.model.WorkspaceState] = Optional.Absent,
    workspaceId: Optional[WorkspaceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.PendingCreateStandbyWorkspacesRequest = {
    import PendingCreateStandbyWorkspacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.PendingCreateStandbyWorkspacesRequest
      .builder()
      .optionallyWith(
        userName.map(value => UserName.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(
        directoryId.map(value => DirectoryId.unwrap(value): java.lang.String)
      )(_.directoryId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        workspaceId.map(value => WorkspaceId.unwrap(value): java.lang.String)
      )(_.workspaceId)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.PendingCreateStandbyWorkspacesRequest.ReadOnly =
    zio.aws.workspaces.model.PendingCreateStandbyWorkspacesRequest
      .wrap(buildAwsValue())
}
object PendingCreateStandbyWorkspacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.PendingCreateStandbyWorkspacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.PendingCreateStandbyWorkspacesRequest =
      zio.aws.workspaces.model.PendingCreateStandbyWorkspacesRequest(
        userName.map(value => value),
        directoryId.map(value => value),
        state.map(value => value),
        workspaceId.map(value => value)
      )
    def userName: Optional[UserName]
    def directoryId: Optional[DirectoryId]
    def state: Optional[zio.aws.workspaces.model.WorkspaceState]
    def workspaceId: Optional[WorkspaceId]
    def getUserName: ZIO[Any, AwsError, UserName] =
      AwsError.unwrapOptionField("userName", userName)
    def getDirectoryId: ZIO[Any, AwsError, DirectoryId] =
      AwsError.unwrapOptionField("directoryId", directoryId)
    def getState: ZIO[Any, AwsError, zio.aws.workspaces.model.WorkspaceState] =
      AwsError.unwrapOptionField("state", state)
    def getWorkspaceId: ZIO[Any, AwsError, WorkspaceId] =
      AwsError.unwrapOptionField("workspaceId", workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.PendingCreateStandbyWorkspacesRequest
  ) extends zio.aws.workspaces.model.PendingCreateStandbyWorkspacesRequest.ReadOnly {
    override val userName: Optional[UserName] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => zio.aws.workspaces.model.primitives.UserName(value))
    override val directoryId: Optional[DirectoryId] = zio.aws.core.internal
      .optionalFromNullable(impl.directoryId())
      .map(value => zio.aws.workspaces.model.primitives.DirectoryId(value))
    override val state: Optional[zio.aws.workspaces.model.WorkspaceState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.workspaces.model.WorkspaceState.wrap(value))
    override val workspaceId: Optional[WorkspaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.workspaceId())
      .map(value => zio.aws.workspaces.model.primitives.WorkspaceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.PendingCreateStandbyWorkspacesRequest
  ): zio.aws.workspaces.model.PendingCreateStandbyWorkspacesRequest.ReadOnly =
    new Wrapper(impl)
}
