package zio.aws.workspaces.model
import scala.jdk.CollectionConverters.*
sealed trait OperatingSystemName {
  def unwrap
      : software.amazon.awssdk.services.workspaces.model.OperatingSystemName
}
object OperatingSystemName {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.OperatingSystemName
  ): zio.aws.workspaces.model.OperatingSystemName = value match {
    case software.amazon.awssdk.services.workspaces.model.OperatingSystemName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.OperatingSystemName.AMAZON_LINUX_2 =>
      val r = AMAZON_LINUX_2
      r
    case software.amazon.awssdk.services.workspaces.model.OperatingSystemName.UBUNTU_18_04 =>
      val r = UBUNTU_18_04
      r
    case software.amazon.awssdk.services.workspaces.model.OperatingSystemName.UBUNTU_20_04 =>
      val r = UBUNTU_20_04
      r
    case software.amazon.awssdk.services.workspaces.model.OperatingSystemName.UBUNTU_22_04 =>
      val r = UBUNTU_22_04
      r
    case software.amazon.awssdk.services.workspaces.model.OperatingSystemName.UNKNOWN =>
      val r = UNKNOWN
      r
    case software.amazon.awssdk.services.workspaces.model.OperatingSystemName.WINDOWS_10 =>
      val r = WINDOWS_10
      r
    case software.amazon.awssdk.services.workspaces.model.OperatingSystemName.WINDOWS_11 =>
      val r = WINDOWS_11
      r
    case software.amazon.awssdk.services.workspaces.model.OperatingSystemName.WINDOWS_7 =>
      val r = WINDOWS_7
      r
    case software.amazon.awssdk.services.workspaces.model.OperatingSystemName.WINDOWS_SERVER_2016 =>
      val r = WINDOWS_SERVER_2016
      r
    case software.amazon.awssdk.services.workspaces.model.OperatingSystemName.WINDOWS_SERVER_2019 =>
      val r = WINDOWS_SERVER_2019
      r
    case software.amazon.awssdk.services.workspaces.model.OperatingSystemName.WINDOWS_SERVER_2022 =>
      val r = WINDOWS_SERVER_2022
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.OperatingSystemName {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.OperatingSystemName =
      software.amazon.awssdk.services.workspaces.model.OperatingSystemName.UNKNOWN_TO_SDK_VERSION
  }
  case object AMAZON_LINUX_2
      extends zio.aws.workspaces.model.OperatingSystemName {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.OperatingSystemName =
      software.amazon.awssdk.services.workspaces.model.OperatingSystemName.AMAZON_LINUX_2
  }
  case object UBUNTU_18_04
      extends zio.aws.workspaces.model.OperatingSystemName {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.OperatingSystemName =
      software.amazon.awssdk.services.workspaces.model.OperatingSystemName.UBUNTU_18_04
  }
  case object UBUNTU_20_04
      extends zio.aws.workspaces.model.OperatingSystemName {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.OperatingSystemName =
      software.amazon.awssdk.services.workspaces.model.OperatingSystemName.UBUNTU_20_04
  }
  case object UBUNTU_22_04
      extends zio.aws.workspaces.model.OperatingSystemName {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.OperatingSystemName =
      software.amazon.awssdk.services.workspaces.model.OperatingSystemName.UBUNTU_22_04
  }
  case object UNKNOWN extends zio.aws.workspaces.model.OperatingSystemName {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.OperatingSystemName =
      software.amazon.awssdk.services.workspaces.model.OperatingSystemName.UNKNOWN
  }
  case object WINDOWS_10 extends zio.aws.workspaces.model.OperatingSystemName {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.OperatingSystemName =
      software.amazon.awssdk.services.workspaces.model.OperatingSystemName.WINDOWS_10
  }
  case object WINDOWS_11 extends zio.aws.workspaces.model.OperatingSystemName {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.OperatingSystemName =
      software.amazon.awssdk.services.workspaces.model.OperatingSystemName.WINDOWS_11
  }
  case object WINDOWS_7 extends zio.aws.workspaces.model.OperatingSystemName {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.OperatingSystemName =
      software.amazon.awssdk.services.workspaces.model.OperatingSystemName.WINDOWS_7
  }
  case object WINDOWS_SERVER_2016
      extends zio.aws.workspaces.model.OperatingSystemName {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.OperatingSystemName =
      software.amazon.awssdk.services.workspaces.model.OperatingSystemName.WINDOWS_SERVER_2016
  }
  case object WINDOWS_SERVER_2019
      extends zio.aws.workspaces.model.OperatingSystemName {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.OperatingSystemName =
      software.amazon.awssdk.services.workspaces.model.OperatingSystemName.WINDOWS_SERVER_2019
  }
  case object WINDOWS_SERVER_2022
      extends zio.aws.workspaces.model.OperatingSystemName {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.OperatingSystemName =
      software.amazon.awssdk.services.workspaces.model.OperatingSystemName.WINDOWS_SERVER_2022
  }
}
