package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.DirectoryId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifySamlPropertiesRequest(
    resourceId: DirectoryId,
    samlProperties: Optional[zio.aws.workspaces.model.SamlProperties] =
      Optional.Absent,
    propertiesToDelete: Optional[
      Iterable[zio.aws.workspaces.model.DeletableSamlProperty]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ModifySamlPropertiesRequest = {
    import ModifySamlPropertiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ModifySamlPropertiesRequest
      .builder()
      .resourceId(DirectoryId.unwrap(resourceId): java.lang.String)
      .optionallyWith(samlProperties.map(value => value.buildAwsValue()))(
        _.samlProperties
      )
      .optionallyWith(
        propertiesToDelete.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.propertiesToDeleteWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.ModifySamlPropertiesRequest.ReadOnly =
    zio.aws.workspaces.model.ModifySamlPropertiesRequest.wrap(buildAwsValue())
}
object ModifySamlPropertiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ModifySamlPropertiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ModifySamlPropertiesRequest =
      zio.aws.workspaces.model.ModifySamlPropertiesRequest(
        resourceId,
        samlProperties.map(value => value.asEditable),
        propertiesToDelete.map(value => value)
      )
    def resourceId: DirectoryId
    def samlProperties
        : Optional[zio.aws.workspaces.model.SamlProperties.ReadOnly]
    def propertiesToDelete
        : Optional[List[zio.aws.workspaces.model.DeletableSamlProperty]]
    def getResourceId: ZIO[Any, Nothing, DirectoryId] = ZIO.succeed(resourceId)
    def getSamlProperties
        : ZIO[Any, AwsError, zio.aws.workspaces.model.SamlProperties.ReadOnly] =
      AwsError.unwrapOptionField("samlProperties", samlProperties)
    def getPropertiesToDelete: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.DeletableSamlProperty
    ]] = AwsError.unwrapOptionField("propertiesToDelete", propertiesToDelete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ModifySamlPropertiesRequest
  ) extends zio.aws.workspaces.model.ModifySamlPropertiesRequest.ReadOnly {
    override val resourceId: DirectoryId =
      zio.aws.workspaces.model.primitives.DirectoryId(impl.resourceId())
    override val samlProperties
        : Optional[zio.aws.workspaces.model.SamlProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.samlProperties())
        .map(value => zio.aws.workspaces.model.SamlProperties.wrap(value))
    override val propertiesToDelete
        : Optional[List[zio.aws.workspaces.model.DeletableSamlProperty]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propertiesToDelete())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.DeletableSamlProperty.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ModifySamlPropertiesRequest
  ): zio.aws.workspaces.model.ModifySamlPropertiesRequest.ReadOnly =
    new Wrapper(impl)
}
