package zio.aws.workspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.workspaces.model.primitives.{
  WorkspaceImageId,
  Timestamp,
  NonEmptyString
}
import scala.jdk.CollectionConverters.*
final case class ImageResourceAssociation(
    associatedResourceId: Optional[NonEmptyString] = Optional.Absent,
    associatedResourceType: Optional[
      zio.aws.workspaces.model.ImageAssociatedResourceType
    ] = Optional.Absent,
    created: Optional[Timestamp] = Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent,
    imageId: Optional[WorkspaceImageId] = Optional.Absent,
    state: Optional[zio.aws.workspaces.model.AssociationState] =
      Optional.Absent,
    stateReason: Optional[zio.aws.workspaces.model.AssociationStateReason] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ImageResourceAssociation = {
    import ImageResourceAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ImageResourceAssociation
      .builder()
      .optionallyWith(
        associatedResourceId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.associatedResourceId)
      .optionallyWith(associatedResourceType.map(value => value.unwrap))(
        _.associatedResourceType
      )
      .optionallyWith(created.map(value => Timestamp.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        imageId.map(value => WorkspaceImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateReason.map(value => value.buildAwsValue()))(
        _.stateReason
      )
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.ImageResourceAssociation.ReadOnly =
    zio.aws.workspaces.model.ImageResourceAssociation.wrap(buildAwsValue())
}
object ImageResourceAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ImageResourceAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ImageResourceAssociation =
      zio.aws.workspaces.model.ImageResourceAssociation(
        associatedResourceId.map(value => value),
        associatedResourceType.map(value => value),
        created.map(value => value),
        lastUpdatedTime.map(value => value),
        imageId.map(value => value),
        state.map(value => value),
        stateReason.map(value => value.asEditable)
      )
    def associatedResourceId: Optional[NonEmptyString]
    def associatedResourceType
        : Optional[zio.aws.workspaces.model.ImageAssociatedResourceType]
    def created: Optional[Timestamp]
    def lastUpdatedTime: Optional[Timestamp]
    def imageId: Optional[WorkspaceImageId]
    def state: Optional[zio.aws.workspaces.model.AssociationState]
    def stateReason
        : Optional[zio.aws.workspaces.model.AssociationStateReason.ReadOnly]
    def getAssociatedResourceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("associatedResourceId", associatedResourceId)
    def getAssociatedResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.ImageAssociatedResourceType
    ] = AwsError.unwrapOptionField(
      "associatedResourceType",
      associatedResourceType
    )
    def getCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("created", created)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getImageId: ZIO[Any, AwsError, WorkspaceImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getState
        : ZIO[Any, AwsError, zio.aws.workspaces.model.AssociationState] =
      AwsError.unwrapOptionField("state", state)
    def getStateReason: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.AssociationStateReason.ReadOnly
    ] = AwsError.unwrapOptionField("stateReason", stateReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ImageResourceAssociation
  ) extends zio.aws.workspaces.model.ImageResourceAssociation.ReadOnly {
    override val associatedResourceId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedResourceId())
        .map(value => zio.aws.workspaces.model.primitives.NonEmptyString(value))
    override val associatedResourceType
        : Optional[zio.aws.workspaces.model.ImageAssociatedResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedResourceType())
        .map(value =>
          zio.aws.workspaces.model.ImageAssociatedResourceType.wrap(value)
        )
    override val created: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.workspaces.model.primitives.Timestamp(value))
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.workspaces.model.primitives.Timestamp(value))
    override val imageId: Optional[WorkspaceImageId] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.workspaces.model.primitives.WorkspaceImageId(value))
    override val state: Optional[zio.aws.workspaces.model.AssociationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.workspaces.model.AssociationState.wrap(value))
    override val stateReason
        : Optional[zio.aws.workspaces.model.AssociationStateReason.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateReason())
        .map(value =>
          zio.aws.workspaces.model.AssociationStateReason.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ImageResourceAssociation
  ): zio.aws.workspaces.model.ImageResourceAssociation.ReadOnly = new Wrapper(
    impl
  )
}
