package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{Description, WorkspaceErrorCode}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FailedCreateStandbyWorkspacesRequest(
    standbyWorkspaceRequest: Optional[
      zio.aws.workspaces.model.StandbyWorkspace
    ] = Optional.Absent,
    errorCode: Optional[WorkspaceErrorCode] = Optional.Absent,
    errorMessage: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.FailedCreateStandbyWorkspacesRequest = {
    import FailedCreateStandbyWorkspacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.FailedCreateStandbyWorkspacesRequest
      .builder()
      .optionallyWith(
        standbyWorkspaceRequest.map(value => value.buildAwsValue())
      )(_.standbyWorkspaceRequest)
      .optionallyWith(
        errorCode.map(value =>
          WorkspaceErrorCode.unwrap(value): java.lang.String
        )
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => Description.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.FailedCreateStandbyWorkspacesRequest.ReadOnly =
    zio.aws.workspaces.model.FailedCreateStandbyWorkspacesRequest
      .wrap(buildAwsValue())
}
object FailedCreateStandbyWorkspacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.FailedCreateStandbyWorkspacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.FailedCreateStandbyWorkspacesRequest =
      zio.aws.workspaces.model.FailedCreateStandbyWorkspacesRequest(
        standbyWorkspaceRequest.map(value => value.asEditable),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def standbyWorkspaceRequest
        : Optional[zio.aws.workspaces.model.StandbyWorkspace.ReadOnly]
    def errorCode: Optional[WorkspaceErrorCode]
    def errorMessage: Optional[Description]
    def getStandbyWorkspaceRequest: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.StandbyWorkspace.ReadOnly
    ] = AwsError.unwrapOptionField(
      "standbyWorkspaceRequest",
      standbyWorkspaceRequest
    )
    def getErrorCode: ZIO[Any, AwsError, WorkspaceErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.FailedCreateStandbyWorkspacesRequest
  ) extends zio.aws.workspaces.model.FailedCreateStandbyWorkspacesRequest.ReadOnly {
    override val standbyWorkspaceRequest
        : Optional[zio.aws.workspaces.model.StandbyWorkspace.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.standbyWorkspaceRequest())
        .map(value => zio.aws.workspaces.model.StandbyWorkspace.wrap(value))
    override val errorCode: Optional[WorkspaceErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value =>
        zio.aws.workspaces.model.primitives.WorkspaceErrorCode(value)
      )
    override val errorMessage: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.workspaces.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.FailedCreateStandbyWorkspacesRequest
  ): zio.aws.workspaces.model.FailedCreateStandbyWorkspacesRequest.ReadOnly =
    new Wrapper(impl)
}
