package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.Description
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ErrorDetails(
    errorCode: Optional[
      zio.aws.workspaces.model.WorkspaceImageErrorDetailCode
    ] = Optional.Absent,
    errorMessage: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ErrorDetails = {
    import ErrorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ErrorDetails
      .builder()
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => Description.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.ErrorDetails.ReadOnly =
    zio.aws.workspaces.model.ErrorDetails.wrap(buildAwsValue())
}
object ErrorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ErrorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ErrorDetails =
      zio.aws.workspaces.model.ErrorDetails(
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def errorCode
        : Optional[zio.aws.workspaces.model.WorkspaceImageErrorDetailCode]
    def errorMessage: Optional[Description]
    def getErrorCode: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.WorkspaceImageErrorDetailCode
    ] = AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ErrorDetails
  ) extends zio.aws.workspaces.model.ErrorDetails.ReadOnly {
    override val errorCode
        : Optional[zio.aws.workspaces.model.WorkspaceImageErrorDetailCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value =>
          zio.aws.workspaces.model.WorkspaceImageErrorDetailCode.wrap(value)
        )
    override val errorMessage: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.workspaces.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ErrorDetails
  ): zio.aws.workspaces.model.ErrorDetails.ReadOnly = new Wrapper(impl)
}
