package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{IpGroupId, DirectoryId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DisassociateIpGroupsRequest(
    directoryId: DirectoryId,
    groupIds: Iterable[IpGroupId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsRequest = {
    import DisassociateIpGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsRequest
      .builder()
      .directoryId(DirectoryId.unwrap(directoryId): java.lang.String)
      .groupIds(groupIds.map { item =>
        IpGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DisassociateIpGroupsRequest.ReadOnly =
    zio.aws.workspaces.model.DisassociateIpGroupsRequest.wrap(buildAwsValue())
}
object DisassociateIpGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DisassociateIpGroupsRequest =
      zio.aws.workspaces.model
        .DisassociateIpGroupsRequest(directoryId, groupIds)
    def directoryId: DirectoryId
    def groupIds: List[IpGroupId]
    def getDirectoryId: ZIO[Any, Nothing, DirectoryId] =
      ZIO.succeed(directoryId)
    def getGroupIds: ZIO[Any, Nothing, List[IpGroupId]] = ZIO.succeed(groupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsRequest
  ) extends zio.aws.workspaces.model.DisassociateIpGroupsRequest.ReadOnly {
    override val directoryId: DirectoryId =
      zio.aws.workspaces.model.primitives.DirectoryId(impl.directoryId())
    override val groupIds: List[IpGroupId] = impl
      .groupIds()
      .asScala
      .map { item =>
        zio.aws.workspaces.model.primitives.IpGroupId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsRequest
  ): zio.aws.workspaces.model.DisassociateIpGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
