package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspacesResponse(
    workspaces: Optional[Iterable[zio.aws.workspaces.model.Workspace]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse = {
    import DescribeWorkspacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse
      .builder()
      .optionallyWith(
        workspaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workspaces)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.DescribeWorkspacesResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeWorkspacesResponse.wrap(buildAwsValue())
}
object DescribeWorkspacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeWorkspacesResponse =
      zio.aws.workspaces.model.DescribeWorkspacesResponse(
        workspaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def workspaces: Optional[List[zio.aws.workspaces.model.Workspace.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getWorkspaces: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.Workspace.ReadOnly
    ]] = AwsError.unwrapOptionField("workspaces", workspaces)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse
  ) extends zio.aws.workspaces.model.DescribeWorkspacesResponse.ReadOnly {
    override val workspaces
        : Optional[List[zio.aws.workspaces.model.Workspace.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workspaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.Workspace.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse
  ): zio.aws.workspaces.model.DescribeWorkspacesResponse.ReadOnly = new Wrapper(
    impl
  )
}
