package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.WorkspaceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspaceSnapshotsRequest(workspaceId: WorkspaceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsRequest = {
    import DescribeWorkspaceSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsRequest
      .builder()
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeWorkspaceSnapshotsRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeWorkspaceSnapshotsRequest
      .wrap(buildAwsValue())
}
object DescribeWorkspaceSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeWorkspaceSnapshotsRequest =
      zio.aws.workspaces.model.DescribeWorkspaceSnapshotsRequest(workspaceId)
    def workspaceId: WorkspaceId
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsRequest
  ) extends zio.aws.workspaces.model.DescribeWorkspaceSnapshotsRequest.ReadOnly {
    override val workspaceId: WorkspaceId =
      zio.aws.workspaces.model.primitives.WorkspaceId(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsRequest
  ): zio.aws.workspaces.model.DescribeWorkspaceSnapshotsRequest.ReadOnly =
    new Wrapper(impl)
}
