package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.WorkspaceImageId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeImageAssociationsRequest(
    imageId: WorkspaceImageId,
    associatedResourceTypes: Iterable[
      zio.aws.workspaces.model.ImageAssociatedResourceType
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeImageAssociationsRequest = {
    import DescribeImageAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeImageAssociationsRequest
      .builder()
      .imageId(WorkspaceImageId.unwrap(imageId): java.lang.String)
      .associatedResourceTypesWithStrings(associatedResourceTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeImageAssociationsRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeImageAssociationsRequest
      .wrap(buildAwsValue())
}
object DescribeImageAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeImageAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeImageAssociationsRequest =
      zio.aws.workspaces.model
        .DescribeImageAssociationsRequest(imageId, associatedResourceTypes)
    def imageId: WorkspaceImageId
    def associatedResourceTypes
        : List[zio.aws.workspaces.model.ImageAssociatedResourceType]
    def getImageId: ZIO[Any, Nothing, WorkspaceImageId] = ZIO.succeed(imageId)
    def getAssociatedResourceTypes: ZIO[Any, Nothing, List[
      zio.aws.workspaces.model.ImageAssociatedResourceType
    ]] = ZIO.succeed(associatedResourceTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeImageAssociationsRequest
  ) extends zio.aws.workspaces.model.DescribeImageAssociationsRequest.ReadOnly {
    override val imageId: WorkspaceImageId =
      zio.aws.workspaces.model.primitives.WorkspaceImageId(impl.imageId())
    override val associatedResourceTypes
        : List[zio.aws.workspaces.model.ImageAssociatedResourceType] = impl
      .associatedResourceTypes()
      .asScala
      .map { item =>
        zio.aws.workspaces.model.ImageAssociatedResourceType.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeImageAssociationsRequest
  ): zio.aws.workspaces.model.DescribeImageAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
