package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeBundleAssociationsResponse(
    associations: Optional[
      Iterable[zio.aws.workspaces.model.BundleResourceAssociation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeBundleAssociationsResponse = {
    import DescribeBundleAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeBundleAssociationsResponse
      .builder()
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeBundleAssociationsResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeBundleAssociationsResponse
      .wrap(buildAwsValue())
}
object DescribeBundleAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeBundleAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DescribeBundleAssociationsResponse =
      zio.aws.workspaces.model.DescribeBundleAssociationsResponse(
        associations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def associations: Optional[
      List[zio.aws.workspaces.model.BundleResourceAssociation.ReadOnly]
    ]
    def getAssociations: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.BundleResourceAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("associations", associations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeBundleAssociationsResponse
  ) extends zio.aws.workspaces.model.DescribeBundleAssociationsResponse.ReadOnly {
    override val associations: Optional[
      List[zio.aws.workspaces.model.BundleResourceAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.associations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.BundleResourceAssociation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeBundleAssociationsResponse
  ): zio.aws.workspaces.model.DescribeBundleAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
