package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeApplicationAssociationsResponse(
    associations: Optional[
      Iterable[zio.aws.workspaces.model.ApplicationResourceAssociation]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsResponse = {
    import DescribeApplicationAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsResponse
      .builder()
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeApplicationAssociationsResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeApplicationAssociationsResponse
      .wrap(buildAwsValue())
}
object DescribeApplicationAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DescribeApplicationAssociationsResponse =
      zio.aws.workspaces.model.DescribeApplicationAssociationsResponse(
        associations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def associations: Optional[
      List[zio.aws.workspaces.model.ApplicationResourceAssociation.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getAssociations: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.ApplicationResourceAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("associations", associations)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsResponse
  ) extends zio.aws.workspaces.model.DescribeApplicationAssociationsResponse.ReadOnly {
    override val associations: Optional[
      List[zio.aws.workspaces.model.ApplicationResourceAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.associations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.ApplicationResourceAssociation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsResponse
  ): zio.aws.workspaces.model.DescribeApplicationAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
