package zio.aws.workspaces.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.workspaces.model.primitives.{
  WorkSpaceApplicationId,
  PaginationToken,
  Limit
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeApplicationAssociationsRequest(
    maxResults: Optional[Limit] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    applicationId: WorkSpaceApplicationId,
    associatedResourceTypes: Iterable[
      zio.aws.workspaces.model.ApplicationAssociatedResourceType
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest = {
    import DescribeApplicationAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest
      .builder()
      .optionallyWith(maxResults.map(value => Limit.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .applicationId(
        WorkSpaceApplicationId.unwrap(applicationId): java.lang.String
      )
      .associatedResourceTypesWithStrings(associatedResourceTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeApplicationAssociationsRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeApplicationAssociationsRequest
      .wrap(buildAwsValue())
}
object DescribeApplicationAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DescribeApplicationAssociationsRequest =
      zio.aws.workspaces.model.DescribeApplicationAssociationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        applicationId,
        associatedResourceTypes
      )
    def maxResults: Optional[Limit]
    def nextToken: Optional[PaginationToken]
    def applicationId: WorkSpaceApplicationId
    def associatedResourceTypes
        : List[zio.aws.workspaces.model.ApplicationAssociatedResourceType]
    def getMaxResults: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getApplicationId: ZIO[Any, Nothing, WorkSpaceApplicationId] =
      ZIO.succeed(applicationId)
    def getAssociatedResourceTypes: ZIO[Any, Nothing, List[
      zio.aws.workspaces.model.ApplicationAssociatedResourceType
    ]] = ZIO.succeed(associatedResourceTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest
  ) extends zio.aws.workspaces.model.DescribeApplicationAssociationsRequest.ReadOnly {
    override val maxResults: Optional[Limit] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.workspaces.model.primitives.Limit(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
    override val applicationId: WorkSpaceApplicationId =
      zio.aws.workspaces.model.primitives
        .WorkSpaceApplicationId(impl.applicationId())
    override val associatedResourceTypes
        : List[zio.aws.workspaces.model.ApplicationAssociatedResourceType] =
      impl
        .associatedResourceTypes()
        .asScala
        .map { item =>
          zio.aws.workspaces.model.ApplicationAssociatedResourceType.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest
  ): zio.aws.workspaces.model.DescribeApplicationAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
