package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{BooleanObject, WorkspaceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeployWorkspaceApplicationsRequest(
    workspaceId: WorkspaceId,
    force: Optional[BooleanObject] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DeployWorkspaceApplicationsRequest = {
    import DeployWorkspaceApplicationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DeployWorkspaceApplicationsRequest
      .builder()
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DeployWorkspaceApplicationsRequest.ReadOnly =
    zio.aws.workspaces.model.DeployWorkspaceApplicationsRequest
      .wrap(buildAwsValue())
}
object DeployWorkspaceApplicationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DeployWorkspaceApplicationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DeployWorkspaceApplicationsRequest =
      zio.aws.workspaces.model.DeployWorkspaceApplicationsRequest(
        workspaceId,
        force.map(value => value)
      )
    def workspaceId: WorkspaceId
    def force: Optional[BooleanObject]
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
    def getForce: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DeployWorkspaceApplicationsRequest
  ) extends zio.aws.workspaces.model.DeployWorkspaceApplicationsRequest.ReadOnly {
    override val workspaceId: WorkspaceId =
      zio.aws.workspaces.model.primitives.WorkspaceId(impl.workspaceId())
    override val force: Optional[BooleanObject] = zio.aws.core.internal
      .optionalFromNullable(impl.force())
      .map(value => value: BooleanObject)
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DeployWorkspaceApplicationsRequest
  ): zio.aws.workspaces.model.DeployWorkspaceApplicationsRequest.ReadOnly =
    new Wrapper(impl)
}
