package zio.aws.workspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.workspaces.model.primitives.{Timestamp, BundleId, NonEmptyString}
import scala.jdk.CollectionConverters.*
final case class BundleResourceAssociation(
    associatedResourceId: Optional[NonEmptyString] = Optional.Absent,
    associatedResourceType: Optional[
      zio.aws.workspaces.model.BundleAssociatedResourceType
    ] = Optional.Absent,
    bundleId: Optional[BundleId] = Optional.Absent,
    created: Optional[Timestamp] = Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent,
    state: Optional[zio.aws.workspaces.model.AssociationState] =
      Optional.Absent,
    stateReason: Optional[zio.aws.workspaces.model.AssociationStateReason] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.BundleResourceAssociation = {
    import BundleResourceAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.BundleResourceAssociation
      .builder()
      .optionallyWith(
        associatedResourceId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.associatedResourceId)
      .optionallyWith(associatedResourceType.map(value => value.unwrap))(
        _.associatedResourceType
      )
      .optionallyWith(
        bundleId.map(value => BundleId.unwrap(value): java.lang.String)
      )(_.bundleId)
      .optionallyWith(created.map(value => Timestamp.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateReason.map(value => value.buildAwsValue()))(
        _.stateReason
      )
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.BundleResourceAssociation.ReadOnly =
    zio.aws.workspaces.model.BundleResourceAssociation.wrap(buildAwsValue())
}
object BundleResourceAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.BundleResourceAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.BundleResourceAssociation =
      zio.aws.workspaces.model.BundleResourceAssociation(
        associatedResourceId.map(value => value),
        associatedResourceType.map(value => value),
        bundleId.map(value => value),
        created.map(value => value),
        lastUpdatedTime.map(value => value),
        state.map(value => value),
        stateReason.map(value => value.asEditable)
      )
    def associatedResourceId: Optional[NonEmptyString]
    def associatedResourceType
        : Optional[zio.aws.workspaces.model.BundleAssociatedResourceType]
    def bundleId: Optional[BundleId]
    def created: Optional[Timestamp]
    def lastUpdatedTime: Optional[Timestamp]
    def state: Optional[zio.aws.workspaces.model.AssociationState]
    def stateReason
        : Optional[zio.aws.workspaces.model.AssociationStateReason.ReadOnly]
    def getAssociatedResourceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("associatedResourceId", associatedResourceId)
    def getAssociatedResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.BundleAssociatedResourceType
    ] = AwsError.unwrapOptionField(
      "associatedResourceType",
      associatedResourceType
    )
    def getBundleId: ZIO[Any, AwsError, BundleId] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("created", created)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getState
        : ZIO[Any, AwsError, zio.aws.workspaces.model.AssociationState] =
      AwsError.unwrapOptionField("state", state)
    def getStateReason: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.AssociationStateReason.ReadOnly
    ] = AwsError.unwrapOptionField("stateReason", stateReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.BundleResourceAssociation
  ) extends zio.aws.workspaces.model.BundleResourceAssociation.ReadOnly {
    override val associatedResourceId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedResourceId())
        .map(value => zio.aws.workspaces.model.primitives.NonEmptyString(value))
    override val associatedResourceType
        : Optional[zio.aws.workspaces.model.BundleAssociatedResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedResourceType())
        .map(value =>
          zio.aws.workspaces.model.BundleAssociatedResourceType.wrap(value)
        )
    override val bundleId: Optional[BundleId] = zio.aws.core.internal
      .optionalFromNullable(impl.bundleId())
      .map(value => zio.aws.workspaces.model.primitives.BundleId(value))
    override val created: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.workspaces.model.primitives.Timestamp(value))
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.workspaces.model.primitives.Timestamp(value))
    override val state: Optional[zio.aws.workspaces.model.AssociationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.workspaces.model.AssociationState.wrap(value))
    override val stateReason
        : Optional[zio.aws.workspaces.model.AssociationStateReason.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateReason())
        .map(value =>
          zio.aws.workspaces.model.AssociationStateReason.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.BundleResourceAssociation
  ): zio.aws.workspaces.model.BundleResourceAssociation.ReadOnly = new Wrapper(
    impl
  )
}
