package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.String2048
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociationStateReason(
    errorCode: Optional[zio.aws.workspaces.model.AssociationErrorCode] =
      Optional.Absent,
    errorMessage: Optional[String2048] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.AssociationStateReason = {
    import AssociationStateReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.AssociationStateReason
      .builder()
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => String2048.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.AssociationStateReason.ReadOnly =
    zio.aws.workspaces.model.AssociationStateReason.wrap(buildAwsValue())
}
object AssociationStateReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.AssociationStateReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.AssociationStateReason =
      zio.aws.workspaces.model.AssociationStateReason(
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def errorCode: Optional[zio.aws.workspaces.model.AssociationErrorCode]
    def errorMessage: Optional[String2048]
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.workspaces.model.AssociationErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String2048] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.AssociationStateReason
  ) extends zio.aws.workspaces.model.AssociationStateReason.ReadOnly {
    override val errorCode
        : Optional[zio.aws.workspaces.model.AssociationErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.workspaces.model.AssociationErrorCode.wrap(value))
    override val errorMessage: Optional[String2048] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.workspaces.model.primitives.String2048(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.AssociationStateReason
  ): zio.aws.workspaces.model.AssociationStateReason.ReadOnly = new Wrapper(
    impl
  )
}
