package zio.aws.workspaces.model
import scala.jdk.CollectionConverters.*
sealed trait AssociationState {
  def unwrap: software.amazon.awssdk.services.workspaces.model.AssociationState
}
object AssociationState {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.AssociationState
  ): zio.aws.workspaces.model.AssociationState = value match {
    case software.amazon.awssdk.services.workspaces.model.AssociationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.AssociationState.PENDING_INSTALL =>
      val r = PENDING_INSTALL
      r
    case software.amazon.awssdk.services.workspaces.model.AssociationState.PENDING_INSTALL_DEPLOYMENT =>
      val r = PENDING_INSTALL_DEPLOYMENT
      r
    case software.amazon.awssdk.services.workspaces.model.AssociationState.PENDING_UNINSTALL =>
      val r = PENDING_UNINSTALL
      r
    case software.amazon.awssdk.services.workspaces.model.AssociationState.PENDING_UNINSTALL_DEPLOYMENT =>
      val r = PENDING_UNINSTALL_DEPLOYMENT
      r
    case software.amazon.awssdk.services.workspaces.model.AssociationState.INSTALLING =>
      val r = INSTALLING
      r
    case software.amazon.awssdk.services.workspaces.model.AssociationState.UNINSTALLING =>
      val r = UNINSTALLING
      r
    case software.amazon.awssdk.services.workspaces.model.AssociationState.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.workspaces.model.AssociationState.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.workspaces.model.AssociationState.REMOVED =>
      val r = REMOVED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.AssociationState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationState =
      software.amazon.awssdk.services.workspaces.model.AssociationState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING_INSTALL
      extends zio.aws.workspaces.model.AssociationState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationState =
      software.amazon.awssdk.services.workspaces.model.AssociationState.PENDING_INSTALL
  }
  case object PENDING_INSTALL_DEPLOYMENT
      extends zio.aws.workspaces.model.AssociationState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationState =
      software.amazon.awssdk.services.workspaces.model.AssociationState.PENDING_INSTALL_DEPLOYMENT
  }
  case object PENDING_UNINSTALL
      extends zio.aws.workspaces.model.AssociationState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationState =
      software.amazon.awssdk.services.workspaces.model.AssociationState.PENDING_UNINSTALL
  }
  case object PENDING_UNINSTALL_DEPLOYMENT
      extends zio.aws.workspaces.model.AssociationState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationState =
      software.amazon.awssdk.services.workspaces.model.AssociationState.PENDING_UNINSTALL_DEPLOYMENT
  }
  case object INSTALLING extends zio.aws.workspaces.model.AssociationState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationState =
      software.amazon.awssdk.services.workspaces.model.AssociationState.INSTALLING
  }
  case object UNINSTALLING extends zio.aws.workspaces.model.AssociationState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationState =
      software.amazon.awssdk.services.workspaces.model.AssociationState.UNINSTALLING
  }
  case object ERROR extends zio.aws.workspaces.model.AssociationState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationState =
      software.amazon.awssdk.services.workspaces.model.AssociationState.ERROR
  }
  case object COMPLETED extends zio.aws.workspaces.model.AssociationState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationState =
      software.amazon.awssdk.services.workspaces.model.AssociationState.COMPLETED
  }
  case object REMOVED extends zio.aws.workspaces.model.AssociationState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationState =
      software.amazon.awssdk.services.workspaces.model.AssociationState.REMOVED
  }
}
