package zio.aws.workspaces.model
import scala.jdk.CollectionConverters.*
sealed trait AssociationErrorCode {
  def unwrap
      : software.amazon.awssdk.services.workspaces.model.AssociationErrorCode
}
object AssociationErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.AssociationErrorCode
  ): zio.aws.workspaces.model.AssociationErrorCode = value match {
    case software.amazon.awssdk.services.workspaces.model.AssociationErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.AssociationErrorCode.VALIDATION_ERROR_INSUFFICIENT_DISK_SPACE =>
      val r = `ValidationError.InsufficientDiskSpace`
      r
    case software.amazon.awssdk.services.workspaces.model.AssociationErrorCode.VALIDATION_ERROR_INSUFFICIENT_MEMORY =>
      val r = `ValidationError.InsufficientMemory`
      r
    case software.amazon.awssdk.services.workspaces.model.AssociationErrorCode.VALIDATION_ERROR_UNSUPPORTED_OPERATING_SYSTEM =>
      val r = `ValidationError.UnsupportedOperatingSystem`
      r
    case software.amazon.awssdk.services.workspaces.model.AssociationErrorCode.DEPLOYMENT_ERROR_INTERNAL_SERVER_ERROR =>
      val r = `DeploymentError.InternalServerError`
      r
    case software.amazon.awssdk.services.workspaces.model.AssociationErrorCode.DEPLOYMENT_ERROR_WORKSPACE_UNREACHABLE =>
      val r = `DeploymentError.WorkspaceUnreachable`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.AssociationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationErrorCode =
      software.amazon.awssdk.services.workspaces.model.AssociationErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object `ValidationError.InsufficientDiskSpace`
      extends zio.aws.workspaces.model.AssociationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationErrorCode =
      software.amazon.awssdk.services.workspaces.model.AssociationErrorCode.VALIDATION_ERROR_INSUFFICIENT_DISK_SPACE
  }
  case object `ValidationError.InsufficientMemory`
      extends zio.aws.workspaces.model.AssociationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationErrorCode =
      software.amazon.awssdk.services.workspaces.model.AssociationErrorCode.VALIDATION_ERROR_INSUFFICIENT_MEMORY
  }
  case object `ValidationError.UnsupportedOperatingSystem`
      extends zio.aws.workspaces.model.AssociationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationErrorCode =
      software.amazon.awssdk.services.workspaces.model.AssociationErrorCode.VALIDATION_ERROR_UNSUPPORTED_OPERATING_SYSTEM
  }
  case object `DeploymentError.InternalServerError`
      extends zio.aws.workspaces.model.AssociationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationErrorCode =
      software.amazon.awssdk.services.workspaces.model.AssociationErrorCode.DEPLOYMENT_ERROR_INTERNAL_SERVER_ERROR
  }
  case object `DeploymentError.WorkspaceUnreachable`
      extends zio.aws.workspaces.model.AssociationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.AssociationErrorCode =
      software.amazon.awssdk.services.workspaces.model.AssociationErrorCode.DEPLOYMENT_ERROR_WORKSPACE_UNREACHABLE
  }
}
