package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{WorkSpaceApplicationId, WorkspaceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AssociateWorkspaceApplicationRequest(
    workspaceId: WorkspaceId,
    applicationId: WorkSpaceApplicationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.AssociateWorkspaceApplicationRequest = {
    import AssociateWorkspaceApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.AssociateWorkspaceApplicationRequest
      .builder()
      .workspaceId(WorkspaceId.unwrap(workspaceId): java.lang.String)
      .applicationId(
        WorkSpaceApplicationId.unwrap(applicationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.AssociateWorkspaceApplicationRequest.ReadOnly =
    zio.aws.workspaces.model.AssociateWorkspaceApplicationRequest
      .wrap(buildAwsValue())
}
object AssociateWorkspaceApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.AssociateWorkspaceApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.AssociateWorkspaceApplicationRequest =
      zio.aws.workspaces.model
        .AssociateWorkspaceApplicationRequest(workspaceId, applicationId)
    def workspaceId: WorkspaceId
    def applicationId: WorkSpaceApplicationId
    def getWorkspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceId)
    def getApplicationId: ZIO[Any, Nothing, WorkSpaceApplicationId] =
      ZIO.succeed(applicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.AssociateWorkspaceApplicationRequest
  ) extends zio.aws.workspaces.model.AssociateWorkspaceApplicationRequest.ReadOnly {
    override val workspaceId: WorkspaceId =
      zio.aws.workspaces.model.primitives.WorkspaceId(impl.workspaceId())
    override val applicationId: WorkSpaceApplicationId =
      zio.aws.workspaces.model.primitives
        .WorkSpaceApplicationId(impl.applicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.AssociateWorkspaceApplicationRequest
  ): zio.aws.workspaces.model.AssociateWorkspaceApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
