package zio.aws.workspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.workspaces.model.primitives.{
  Timestamp,
  NonEmptyString,
  WorkSpaceApplicationId
}
import scala.jdk.CollectionConverters.*
final case class ApplicationResourceAssociation(
    applicationId: Optional[WorkSpaceApplicationId] = Optional.Absent,
    associatedResourceId: Optional[NonEmptyString] = Optional.Absent,
    associatedResourceType: Optional[
      zio.aws.workspaces.model.ApplicationAssociatedResourceType
    ] = Optional.Absent,
    created: Optional[Timestamp] = Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent,
    state: Optional[zio.aws.workspaces.model.AssociationState] =
      Optional.Absent,
    stateReason: Optional[zio.aws.workspaces.model.AssociationStateReason] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ApplicationResourceAssociation = {
    import ApplicationResourceAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ApplicationResourceAssociation
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          WorkSpaceApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        associatedResourceId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.associatedResourceId)
      .optionallyWith(associatedResourceType.map(value => value.unwrap))(
        _.associatedResourceType
      )
      .optionallyWith(created.map(value => Timestamp.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateReason.map(value => value.buildAwsValue()))(
        _.stateReason
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.ApplicationResourceAssociation.ReadOnly =
    zio.aws.workspaces.model.ApplicationResourceAssociation
      .wrap(buildAwsValue())
}
object ApplicationResourceAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ApplicationResourceAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ApplicationResourceAssociation =
      zio.aws.workspaces.model.ApplicationResourceAssociation(
        applicationId.map(value => value),
        associatedResourceId.map(value => value),
        associatedResourceType.map(value => value),
        created.map(value => value),
        lastUpdatedTime.map(value => value),
        state.map(value => value),
        stateReason.map(value => value.asEditable)
      )
    def applicationId: Optional[WorkSpaceApplicationId]
    def associatedResourceId: Optional[NonEmptyString]
    def associatedResourceType
        : Optional[zio.aws.workspaces.model.ApplicationAssociatedResourceType]
    def created: Optional[Timestamp]
    def lastUpdatedTime: Optional[Timestamp]
    def state: Optional[zio.aws.workspaces.model.AssociationState]
    def stateReason
        : Optional[zio.aws.workspaces.model.AssociationStateReason.ReadOnly]
    def getApplicationId: ZIO[Any, AwsError, WorkSpaceApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getAssociatedResourceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("associatedResourceId", associatedResourceId)
    def getAssociatedResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.ApplicationAssociatedResourceType
    ] = AwsError.unwrapOptionField(
      "associatedResourceType",
      associatedResourceType
    )
    def getCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("created", created)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getState
        : ZIO[Any, AwsError, zio.aws.workspaces.model.AssociationState] =
      AwsError.unwrapOptionField("state", state)
    def getStateReason: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.AssociationStateReason.ReadOnly
    ] = AwsError.unwrapOptionField("stateReason", stateReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ApplicationResourceAssociation
  ) extends zio.aws.workspaces.model.ApplicationResourceAssociation.ReadOnly {
    override val applicationId: Optional[WorkSpaceApplicationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationId())
        .map(value =>
          zio.aws.workspaces.model.primitives.WorkSpaceApplicationId(value)
        )
    override val associatedResourceId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedResourceId())
        .map(value => zio.aws.workspaces.model.primitives.NonEmptyString(value))
    override val associatedResourceType
        : Optional[zio.aws.workspaces.model.ApplicationAssociatedResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedResourceType())
        .map(value =>
          zio.aws.workspaces.model.ApplicationAssociatedResourceType.wrap(value)
        )
    override val created: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.workspaces.model.primitives.Timestamp(value))
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.workspaces.model.primitives.Timestamp(value))
    override val state: Optional[zio.aws.workspaces.model.AssociationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.workspaces.model.AssociationState.wrap(value))
    override val stateReason
        : Optional[zio.aws.workspaces.model.AssociationStateReason.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateReason())
        .map(value =>
          zio.aws.workspaces.model.AssociationStateReason.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ApplicationResourceAssociation
  ): zio.aws.workspaces.model.ApplicationResourceAssociation.ReadOnly =
    new Wrapper(impl)
}
