package zio.aws.workspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.workspaces.model.primitives.{Timestamp, WorkspaceId}
import scala.jdk.CollectionConverters.*
final case class WorkspaceConnectionStatus(
    workspaceId: Optional[WorkspaceId] = Optional.Absent,
    connectionState: Optional[zio.aws.workspaces.model.ConnectionState] =
      Optional.Absent,
    connectionStateCheckTimestamp: Optional[Timestamp] = Optional.Absent,
    lastKnownUserConnectionTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.WorkspaceConnectionStatus = {
    import WorkspaceConnectionStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.WorkspaceConnectionStatus
      .builder()
      .optionallyWith(
        workspaceId.map(value => WorkspaceId.unwrap(value): java.lang.String)
      )(_.workspaceId)
      .optionallyWith(connectionState.map(value => value.unwrap))(
        _.connectionState
      )
      .optionallyWith(
        connectionStateCheckTimestamp.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.connectionStateCheckTimestamp)
      .optionallyWith(
        lastKnownUserConnectionTimestamp.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.lastKnownUserConnectionTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.WorkspaceConnectionStatus.ReadOnly =
    zio.aws.workspaces.model.WorkspaceConnectionStatus.wrap(buildAwsValue())
}
object WorkspaceConnectionStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.WorkspaceConnectionStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.WorkspaceConnectionStatus =
      zio.aws.workspaces.model.WorkspaceConnectionStatus(
        workspaceId.map(value => value),
        connectionState.map(value => value),
        connectionStateCheckTimestamp.map(value => value),
        lastKnownUserConnectionTimestamp.map(value => value)
      )
    def workspaceId: Optional[WorkspaceId]
    def connectionState: Optional[zio.aws.workspaces.model.ConnectionState]
    def connectionStateCheckTimestamp: Optional[Timestamp]
    def lastKnownUserConnectionTimestamp: Optional[Timestamp]
    def getWorkspaceId: ZIO[Any, AwsError, WorkspaceId] =
      AwsError.unwrapOptionField("workspaceId", workspaceId)
    def getConnectionState
        : ZIO[Any, AwsError, zio.aws.workspaces.model.ConnectionState] =
      AwsError.unwrapOptionField("connectionState", connectionState)
    def getConnectionStateCheckTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "connectionStateCheckTimestamp",
        connectionStateCheckTimestamp
      )
    def getLastKnownUserConnectionTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "lastKnownUserConnectionTimestamp",
        lastKnownUserConnectionTimestamp
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceConnectionStatus
  ) extends zio.aws.workspaces.model.WorkspaceConnectionStatus.ReadOnly {
    override val workspaceId: Optional[WorkspaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.workspaceId())
      .map(value => zio.aws.workspaces.model.primitives.WorkspaceId(value))
    override val connectionState
        : Optional[zio.aws.workspaces.model.ConnectionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionState())
        .map(value => zio.aws.workspaces.model.ConnectionState.wrap(value))
    override val connectionStateCheckTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionStateCheckTimestamp())
        .map(value => zio.aws.workspaces.model.primitives.Timestamp(value))
    override val lastKnownUserConnectionTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastKnownUserConnectionTimestamp())
        .map(value => zio.aws.workspaces.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceConnectionStatus
  ): zio.aws.workspaces.model.WorkspaceConnectionStatus.ReadOnly = new Wrapper(
    impl
  )
}
