package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{WorkspaceImageId, BundleId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateWorkspaceBundleRequest(
    bundleId: Optional[BundleId] = Optional.Absent,
    imageId: Optional[WorkspaceImageId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleRequest = {
    import UpdateWorkspaceBundleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleRequest
      .builder()
      .optionallyWith(
        bundleId.map(value => BundleId.unwrap(value): java.lang.String)
      )(_.bundleId)
      .optionallyWith(
        imageId.map(value => WorkspaceImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.UpdateWorkspaceBundleRequest.ReadOnly =
    zio.aws.workspaces.model.UpdateWorkspaceBundleRequest.wrap(buildAwsValue())
}
object UpdateWorkspaceBundleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.UpdateWorkspaceBundleRequest =
      zio.aws.workspaces.model.UpdateWorkspaceBundleRequest(
        bundleId.map(value => value),
        imageId.map(value => value)
      )
    def bundleId: Optional[BundleId]
    def imageId: Optional[WorkspaceImageId]
    def getBundleId: ZIO[Any, AwsError, BundleId] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getImageId: ZIO[Any, AwsError, WorkspaceImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleRequest
  ) extends zio.aws.workspaces.model.UpdateWorkspaceBundleRequest.ReadOnly {
    override val bundleId: Optional[BundleId] = zio.aws.core.internal
      .optionalFromNullable(impl.bundleId())
      .map(value => zio.aws.workspaces.model.primitives.BundleId(value))
    override val imageId: Optional[WorkspaceImageId] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.workspaces.model.primitives.WorkspaceImageId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleRequest
  ): zio.aws.workspaces.model.UpdateWorkspaceBundleRequest.ReadOnly =
    new Wrapper(impl)
}
