package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{IpRuleDesc, IpRule}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IpRuleItem(
    ipRule: Optional[IpRule] = Optional.Absent,
    ruleDesc: Optional[IpRuleDesc] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.IpRuleItem = {
    import IpRuleItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.IpRuleItem
      .builder()
      .optionallyWith(
        ipRule.map(value => IpRule.unwrap(value): java.lang.String)
      )(_.ipRule)
      .optionallyWith(
        ruleDesc.map(value => IpRuleDesc.unwrap(value): java.lang.String)
      )(_.ruleDesc)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.IpRuleItem.ReadOnly =
    zio.aws.workspaces.model.IpRuleItem.wrap(buildAwsValue())
}
object IpRuleItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.IpRuleItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.IpRuleItem =
      zio.aws.workspaces.model
        .IpRuleItem(ipRule.map(value => value), ruleDesc.map(value => value))
    def ipRule: Optional[IpRule]
    def ruleDesc: Optional[IpRuleDesc]
    def getIpRule: ZIO[Any, AwsError, IpRule] =
      AwsError.unwrapOptionField("ipRule", ipRule)
    def getRuleDesc: ZIO[Any, AwsError, IpRuleDesc] =
      AwsError.unwrapOptionField("ruleDesc", ruleDesc)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.IpRuleItem
  ) extends zio.aws.workspaces.model.IpRuleItem.ReadOnly {
    override val ipRule: Optional[IpRule] = zio.aws.core.internal
      .optionalFromNullable(impl.ipRule())
      .map(value => zio.aws.workspaces.model.primitives.IpRule(value))
    override val ruleDesc: Optional[IpRuleDesc] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleDesc())
      .map(value => zio.aws.workspaces.model.primitives.IpRuleDesc(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.IpRuleItem
  ): zio.aws.workspaces.model.IpRuleItem.ReadOnly = new Wrapper(impl)
}
