package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.DirectoryId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImportClientBrandingRequest(
    resourceId: DirectoryId,
    deviceTypeWindows: Optional[
      zio.aws.workspaces.model.DefaultImportClientBrandingAttributes
    ] = Optional.Absent,
    deviceTypeOsx: Optional[
      zio.aws.workspaces.model.DefaultImportClientBrandingAttributes
    ] = Optional.Absent,
    deviceTypeAndroid: Optional[
      zio.aws.workspaces.model.DefaultImportClientBrandingAttributes
    ] = Optional.Absent,
    deviceTypeIos: Optional[
      zio.aws.workspaces.model.IosImportClientBrandingAttributes
    ] = Optional.Absent,
    deviceTypeLinux: Optional[
      zio.aws.workspaces.model.DefaultImportClientBrandingAttributes
    ] = Optional.Absent,
    deviceTypeWeb: Optional[
      zio.aws.workspaces.model.DefaultImportClientBrandingAttributes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.ImportClientBrandingRequest = {
    import ImportClientBrandingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.ImportClientBrandingRequest
      .builder()
      .resourceId(DirectoryId.unwrap(resourceId): java.lang.String)
      .optionallyWith(deviceTypeWindows.map(value => value.buildAwsValue()))(
        _.deviceTypeWindows
      )
      .optionallyWith(deviceTypeOsx.map(value => value.buildAwsValue()))(
        _.deviceTypeOsx
      )
      .optionallyWith(deviceTypeAndroid.map(value => value.buildAwsValue()))(
        _.deviceTypeAndroid
      )
      .optionallyWith(deviceTypeIos.map(value => value.buildAwsValue()))(
        _.deviceTypeIos
      )
      .optionallyWith(deviceTypeLinux.map(value => value.buildAwsValue()))(
        _.deviceTypeLinux
      )
      .optionallyWith(deviceTypeWeb.map(value => value.buildAwsValue()))(
        _.deviceTypeWeb
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.ImportClientBrandingRequest.ReadOnly =
    zio.aws.workspaces.model.ImportClientBrandingRequest.wrap(buildAwsValue())
}
object ImportClientBrandingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.ImportClientBrandingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.ImportClientBrandingRequest =
      zio.aws.workspaces.model.ImportClientBrandingRequest(
        resourceId,
        deviceTypeWindows.map(value => value.asEditable),
        deviceTypeOsx.map(value => value.asEditable),
        deviceTypeAndroid.map(value => value.asEditable),
        deviceTypeIos.map(value => value.asEditable),
        deviceTypeLinux.map(value => value.asEditable),
        deviceTypeWeb.map(value => value.asEditable)
      )
    def resourceId: DirectoryId
    def deviceTypeWindows: Optional[
      zio.aws.workspaces.model.DefaultImportClientBrandingAttributes.ReadOnly
    ]
    def deviceTypeOsx: Optional[
      zio.aws.workspaces.model.DefaultImportClientBrandingAttributes.ReadOnly
    ]
    def deviceTypeAndroid: Optional[
      zio.aws.workspaces.model.DefaultImportClientBrandingAttributes.ReadOnly
    ]
    def deviceTypeIos: Optional[
      zio.aws.workspaces.model.IosImportClientBrandingAttributes.ReadOnly
    ]
    def deviceTypeLinux: Optional[
      zio.aws.workspaces.model.DefaultImportClientBrandingAttributes.ReadOnly
    ]
    def deviceTypeWeb: Optional[
      zio.aws.workspaces.model.DefaultImportClientBrandingAttributes.ReadOnly
    ]
    def getResourceId: ZIO[Any, Nothing, DirectoryId] = ZIO.succeed(resourceId)
    def getDeviceTypeWindows: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.DefaultImportClientBrandingAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("deviceTypeWindows", deviceTypeWindows)
    def getDeviceTypeOsx: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.DefaultImportClientBrandingAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("deviceTypeOsx", deviceTypeOsx)
    def getDeviceTypeAndroid: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.DefaultImportClientBrandingAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("deviceTypeAndroid", deviceTypeAndroid)
    def getDeviceTypeIos: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.IosImportClientBrandingAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("deviceTypeIos", deviceTypeIos)
    def getDeviceTypeLinux: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.DefaultImportClientBrandingAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("deviceTypeLinux", deviceTypeLinux)
    def getDeviceTypeWeb: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.DefaultImportClientBrandingAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("deviceTypeWeb", deviceTypeWeb)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.ImportClientBrandingRequest
  ) extends zio.aws.workspaces.model.ImportClientBrandingRequest.ReadOnly {
    override val resourceId: DirectoryId =
      zio.aws.workspaces.model.primitives.DirectoryId(impl.resourceId())
    override val deviceTypeWindows: Optional[
      zio.aws.workspaces.model.DefaultImportClientBrandingAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceTypeWindows())
      .map(value =>
        zio.aws.workspaces.model.DefaultImportClientBrandingAttributes
          .wrap(value)
      )
    override val deviceTypeOsx: Optional[
      zio.aws.workspaces.model.DefaultImportClientBrandingAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceTypeOsx())
      .map(value =>
        zio.aws.workspaces.model.DefaultImportClientBrandingAttributes
          .wrap(value)
      )
    override val deviceTypeAndroid: Optional[
      zio.aws.workspaces.model.DefaultImportClientBrandingAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceTypeAndroid())
      .map(value =>
        zio.aws.workspaces.model.DefaultImportClientBrandingAttributes
          .wrap(value)
      )
    override val deviceTypeIos: Optional[
      zio.aws.workspaces.model.IosImportClientBrandingAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceTypeIos())
      .map(value =>
        zio.aws.workspaces.model.IosImportClientBrandingAttributes.wrap(value)
      )
    override val deviceTypeLinux: Optional[
      zio.aws.workspaces.model.DefaultImportClientBrandingAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceTypeLinux())
      .map(value =>
        zio.aws.workspaces.model.DefaultImportClientBrandingAttributes
          .wrap(value)
      )
    override val deviceTypeWeb: Optional[
      zio.aws.workspaces.model.DefaultImportClientBrandingAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceTypeWeb())
      .map(value =>
        zio.aws.workspaces.model.DefaultImportClientBrandingAttributes
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.ImportClientBrandingRequest
  ): zio.aws.workspaces.model.ImportClientBrandingRequest.ReadOnly =
    new Wrapper(impl)
}
