package zio.aws.workspaces.model
import scala.jdk.CollectionConverters.*
sealed trait ImageType {
  def unwrap: software.amazon.awssdk.services.workspaces.model.ImageType
}
object ImageType {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.ImageType
  ): zio.aws.workspaces.model.ImageType = value match {
    case software.amazon.awssdk.services.workspaces.model.ImageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.ImageType.OWNED =>
      val r = OWNED
      r
    case software.amazon.awssdk.services.workspaces.model.ImageType.SHARED =>
      val r = SHARED
      r
  }
  case object unknownToSdkVersion extends zio.aws.workspaces.model.ImageType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ImageType =
      software.amazon.awssdk.services.workspaces.model.ImageType.UNKNOWN_TO_SDK_VERSION
  }
  case object OWNED extends zio.aws.workspaces.model.ImageType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ImageType =
      software.amazon.awssdk.services.workspaces.model.ImageType.OWNED
  }
  case object SHARED extends zio.aws.workspaces.model.ImageType {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ImageType =
      software.amazon.awssdk.services.workspaces.model.ImageType.SHARED
  }
}
