package zio.aws.workspaces.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.workspaces.model.primitives.{
  WorkspaceId,
  PaginationToken,
  Limit,
  BundleId,
  UserName,
  DirectoryId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspacesRequest(
    workspaceIds: Optional[Iterable[WorkspaceId]] = Optional.Absent,
    directoryId: Optional[DirectoryId] = Optional.Absent,
    userName: Optional[UserName] = Optional.Absent,
    bundleId: Optional[BundleId] = Optional.Absent,
    limit: Optional[Limit] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest = {
    import DescribeWorkspacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest
      .builder()
      .optionallyWith(
        workspaceIds.map(value =>
          value.map { item =>
            WorkspaceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.workspaceIds)
      .optionallyWith(
        directoryId.map(value => DirectoryId.unwrap(value): java.lang.String)
      )(_.directoryId)
      .optionallyWith(
        userName.map(value => UserName.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(
        bundleId.map(value => BundleId.unwrap(value): java.lang.String)
      )(_.bundleId)
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.DescribeWorkspacesRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeWorkspacesRequest.wrap(buildAwsValue())
}
object DescribeWorkspacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeWorkspacesRequest =
      zio.aws.workspaces.model.DescribeWorkspacesRequest(
        workspaceIds.map(value => value),
        directoryId.map(value => value),
        userName.map(value => value),
        bundleId.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def workspaceIds: Optional[List[WorkspaceId]]
    def directoryId: Optional[DirectoryId]
    def userName: Optional[UserName]
    def bundleId: Optional[BundleId]
    def limit: Optional[Limit]
    def nextToken: Optional[PaginationToken]
    def getWorkspaceIds: ZIO[Any, AwsError, List[WorkspaceId]] =
      AwsError.unwrapOptionField("workspaceIds", workspaceIds)
    def getDirectoryId: ZIO[Any, AwsError, DirectoryId] =
      AwsError.unwrapOptionField("directoryId", directoryId)
    def getUserName: ZIO[Any, AwsError, UserName] =
      AwsError.unwrapOptionField("userName", userName)
    def getBundleId: ZIO[Any, AwsError, BundleId] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest
  ) extends zio.aws.workspaces.model.DescribeWorkspacesRequest.ReadOnly {
    override val workspaceIds: Optional[List[WorkspaceId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workspaceIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.primitives.WorkspaceId(item)
          }.toList
        )
    override val directoryId: Optional[DirectoryId] = zio.aws.core.internal
      .optionalFromNullable(impl.directoryId())
      .map(value => zio.aws.workspaces.model.primitives.DirectoryId(value))
    override val userName: Optional[UserName] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => zio.aws.workspaces.model.primitives.UserName(value))
    override val bundleId: Optional[BundleId] = zio.aws.core.internal
      .optionalFromNullable(impl.bundleId())
      .map(value => zio.aws.workspaces.model.primitives.BundleId(value))
    override val limit: Optional[Limit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.workspaces.model.primitives.Limit(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest
  ): zio.aws.workspaces.model.DescribeWorkspacesRequest.ReadOnly = new Wrapper(
    impl
  )
}
