package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{PaginationToken, WorkspaceImageId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspaceImagePermissionsResponse(
    imageId: Optional[WorkspaceImageId] = Optional.Absent,
    imagePermissions: Optional[
      Iterable[zio.aws.workspaces.model.ImagePermission]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsResponse = {
    import DescribeWorkspaceImagePermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsResponse
      .builder()
      .optionallyWith(
        imageId.map(value => WorkspaceImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(
        imagePermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.imagePermissions)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse
      .wrap(buildAwsValue())
}
object DescribeWorkspaceImagePermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse =
      zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse(
        imageId.map(value => value),
        imagePermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def imageId: Optional[WorkspaceImageId]
    def imagePermissions
        : Optional[List[zio.aws.workspaces.model.ImagePermission.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getImageId: ZIO[Any, AwsError, WorkspaceImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getImagePermissions: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.ImagePermission.ReadOnly
    ]] = AwsError.unwrapOptionField("imagePermissions", imagePermissions)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsResponse
  ) extends zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse.ReadOnly {
    override val imageId: Optional[WorkspaceImageId] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.workspaces.model.primitives.WorkspaceImageId(value))
    override val imagePermissions
        : Optional[List[zio.aws.workspaces.model.ImagePermission.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imagePermissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.ImagePermission.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsResponse
  ): zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse.ReadOnly =
    new Wrapper(impl)
}
