package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeTagsRequest(resourceId: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeTagsRequest = {
    import DescribeTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeTagsRequest
      .builder()
      .resourceId(NonEmptyString.unwrap(resourceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.DescribeTagsRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeTagsRequest.wrap(buildAwsValue())
}
object DescribeTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeTagsRequest =
      zio.aws.workspaces.model.DescribeTagsRequest(resourceId)
    def resourceId: NonEmptyString
    def getResourceId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeTagsRequest
  ) extends zio.aws.workspaces.model.DescribeTagsRequest.ReadOnly {
    override val resourceId: NonEmptyString =
      zio.aws.workspaces.model.primitives.NonEmptyString(impl.resourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeTagsRequest
  ): zio.aws.workspaces.model.DescribeTagsRequest.ReadOnly = new Wrapper(impl)
}
