package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  SubnetId,
  SecurityGroupId,
  DirectoryName,
  RegistrationCode,
  IpGroupId,
  IpAddress,
  UserName,
  DirectoryId,
  Alias,
  ARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WorkspaceDirectory(
    directoryId: Optional[DirectoryId] = Optional.Absent,
    alias: Optional[Alias] = Optional.Absent,
    directoryName: Optional[DirectoryName] = Optional.Absent,
    registrationCode: Optional[RegistrationCode] = Optional.Absent,
    subnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    dnsIpAddresses: Optional[Iterable[IpAddress]] = Optional.Absent,
    customerUserName: Optional[UserName] = Optional.Absent,
    iamRoleId: Optional[ARN] = Optional.Absent,
    directoryType: Optional[zio.aws.workspaces.model.WorkspaceDirectoryType] =
      Optional.Absent,
    workspaceSecurityGroupId: Optional[SecurityGroupId] = Optional.Absent,
    state: Optional[zio.aws.workspaces.model.WorkspaceDirectoryState] =
      Optional.Absent,
    workspaceCreationProperties: Optional[
      zio.aws.workspaces.model.DefaultWorkspaceCreationProperties
    ] = Optional.Absent,
    ipGroupIds: Optional[Iterable[IpGroupId]] = Optional.Absent,
    workspaceAccessProperties: Optional[
      zio.aws.workspaces.model.WorkspaceAccessProperties
    ] = Optional.Absent,
    tenancy: Optional[zio.aws.workspaces.model.Tenancy] = Optional.Absent,
    selfservicePermissions: Optional[
      zio.aws.workspaces.model.SelfservicePermissions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.WorkspaceDirectory = {
    import WorkspaceDirectory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.WorkspaceDirectory
      .builder()
      .optionallyWith(
        directoryId.map(value => DirectoryId.unwrap(value): java.lang.String)
      )(_.directoryId)
      .optionallyWith(
        alias.map(value => Alias.unwrap(value): java.lang.String)
      )(_.alias)
      .optionallyWith(
        directoryName.map(value =>
          DirectoryName.unwrap(value): java.lang.String
        )
      )(_.directoryName)
      .optionallyWith(
        registrationCode.map(value =>
          RegistrationCode.unwrap(value): java.lang.String
        )
      )(_.registrationCode)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        dnsIpAddresses.map(value =>
          value.map { item =>
            IpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dnsIpAddresses)
      .optionallyWith(
        customerUserName.map(value => UserName.unwrap(value): java.lang.String)
      )(_.customerUserName)
      .optionallyWith(
        iamRoleId.map(value => ARN.unwrap(value): java.lang.String)
      )(_.iamRoleId)
      .optionallyWith(directoryType.map(value => value.unwrap))(_.directoryType)
      .optionallyWith(
        workspaceSecurityGroupId.map(value =>
          SecurityGroupId.unwrap(value): java.lang.String
        )
      )(_.workspaceSecurityGroupId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        workspaceCreationProperties.map(value => value.buildAwsValue())
      )(_.workspaceCreationProperties)
      .optionallyWith(
        ipGroupIds.map(value =>
          value.map { item =>
            IpGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ipGroupIds)
      .optionallyWith(
        workspaceAccessProperties.map(value => value.buildAwsValue())
      )(_.workspaceAccessProperties)
      .optionallyWith(tenancy.map(value => value.unwrap))(_.tenancy)
      .optionallyWith(
        selfservicePermissions.map(value => value.buildAwsValue())
      )(_.selfservicePermissions)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.WorkspaceDirectory.ReadOnly =
    zio.aws.workspaces.model.WorkspaceDirectory.wrap(buildAwsValue())
}
object WorkspaceDirectory {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.WorkspaceDirectory
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.WorkspaceDirectory =
      zio.aws.workspaces.model.WorkspaceDirectory(
        directoryId.map(value => value),
        alias.map(value => value),
        directoryName.map(value => value),
        registrationCode.map(value => value),
        subnetIds.map(value => value),
        dnsIpAddresses.map(value => value),
        customerUserName.map(value => value),
        iamRoleId.map(value => value),
        directoryType.map(value => value),
        workspaceSecurityGroupId.map(value => value),
        state.map(value => value),
        workspaceCreationProperties.map(value => value.asEditable),
        ipGroupIds.map(value => value),
        workspaceAccessProperties.map(value => value.asEditable),
        tenancy.map(value => value),
        selfservicePermissions.map(value => value.asEditable)
      )
    def directoryId: Optional[DirectoryId]
    def alias: Optional[Alias]
    def directoryName: Optional[DirectoryName]
    def registrationCode: Optional[RegistrationCode]
    def subnetIds: Optional[List[SubnetId]]
    def dnsIpAddresses: Optional[List[IpAddress]]
    def customerUserName: Optional[UserName]
    def iamRoleId: Optional[ARN]
    def directoryType: Optional[zio.aws.workspaces.model.WorkspaceDirectoryType]
    def workspaceSecurityGroupId: Optional[SecurityGroupId]
    def state: Optional[zio.aws.workspaces.model.WorkspaceDirectoryState]
    def workspaceCreationProperties: Optional[
      zio.aws.workspaces.model.DefaultWorkspaceCreationProperties.ReadOnly
    ]
    def ipGroupIds: Optional[List[IpGroupId]]
    def workspaceAccessProperties
        : Optional[zio.aws.workspaces.model.WorkspaceAccessProperties.ReadOnly]
    def tenancy: Optional[zio.aws.workspaces.model.Tenancy]
    def selfservicePermissions
        : Optional[zio.aws.workspaces.model.SelfservicePermissions.ReadOnly]
    def getDirectoryId: ZIO[Any, AwsError, DirectoryId] =
      AwsError.unwrapOptionField("directoryId", directoryId)
    def getAlias: ZIO[Any, AwsError, Alias] =
      AwsError.unwrapOptionField("alias", alias)
    def getDirectoryName: ZIO[Any, AwsError, DirectoryName] =
      AwsError.unwrapOptionField("directoryName", directoryName)
    def getRegistrationCode: ZIO[Any, AwsError, RegistrationCode] =
      AwsError.unwrapOptionField("registrationCode", registrationCode)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getDnsIpAddresses: ZIO[Any, AwsError, List[IpAddress]] =
      AwsError.unwrapOptionField("dnsIpAddresses", dnsIpAddresses)
    def getCustomerUserName: ZIO[Any, AwsError, UserName] =
      AwsError.unwrapOptionField("customerUserName", customerUserName)
    def getIamRoleId: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("iamRoleId", iamRoleId)
    def getDirectoryType
        : ZIO[Any, AwsError, zio.aws.workspaces.model.WorkspaceDirectoryType] =
      AwsError.unwrapOptionField("directoryType", directoryType)
    def getWorkspaceSecurityGroupId: ZIO[Any, AwsError, SecurityGroupId] =
      AwsError.unwrapOptionField(
        "workspaceSecurityGroupId",
        workspaceSecurityGroupId
      )
    def getState
        : ZIO[Any, AwsError, zio.aws.workspaces.model.WorkspaceDirectoryState] =
      AwsError.unwrapOptionField("state", state)
    def getWorkspaceCreationProperties: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.DefaultWorkspaceCreationProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workspaceCreationProperties",
      workspaceCreationProperties
    )
    def getIpGroupIds: ZIO[Any, AwsError, List[IpGroupId]] =
      AwsError.unwrapOptionField("ipGroupIds", ipGroupIds)
    def getWorkspaceAccessProperties: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.WorkspaceAccessProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workspaceAccessProperties",
      workspaceAccessProperties
    )
    def getTenancy: ZIO[Any, AwsError, zio.aws.workspaces.model.Tenancy] =
      AwsError.unwrapOptionField("tenancy", tenancy)
    def getSelfservicePermissions: ZIO[
      Any,
      AwsError,
      zio.aws.workspaces.model.SelfservicePermissions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "selfservicePermissions",
      selfservicePermissions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceDirectory
  ) extends zio.aws.workspaces.model.WorkspaceDirectory.ReadOnly {
    override val directoryId: Optional[DirectoryId] = zio.aws.core.internal
      .optionalFromNullable(impl.directoryId())
      .map(value => zio.aws.workspaces.model.primitives.DirectoryId(value))
    override val alias: Optional[Alias] = zio.aws.core.internal
      .optionalFromNullable(impl.alias())
      .map(value => zio.aws.workspaces.model.primitives.Alias(value))
    override val directoryName: Optional[DirectoryName] = zio.aws.core.internal
      .optionalFromNullable(impl.directoryName())
      .map(value => zio.aws.workspaces.model.primitives.DirectoryName(value))
    override val registrationCode: Optional[RegistrationCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registrationCode())
        .map(value =>
          zio.aws.workspaces.model.primitives.RegistrationCode(value)
        )
    override val subnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.primitives.SubnetId(item)
        }.toList
      )
    override val dnsIpAddresses: Optional[List[IpAddress]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsIpAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.primitives.IpAddress(item)
          }.toList
        )
    override val customerUserName: Optional[UserName] = zio.aws.core.internal
      .optionalFromNullable(impl.customerUserName())
      .map(value => zio.aws.workspaces.model.primitives.UserName(value))
    override val iamRoleId: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleId())
      .map(value => zio.aws.workspaces.model.primitives.ARN(value))
    override val directoryType
        : Optional[zio.aws.workspaces.model.WorkspaceDirectoryType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directoryType())
        .map(value =>
          zio.aws.workspaces.model.WorkspaceDirectoryType.wrap(value)
        )
    override val workspaceSecurityGroupId: Optional[SecurityGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workspaceSecurityGroupId())
        .map(value =>
          zio.aws.workspaces.model.primitives.SecurityGroupId(value)
        )
    override val state
        : Optional[zio.aws.workspaces.model.WorkspaceDirectoryState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.workspaces.model.WorkspaceDirectoryState.wrap(value)
        )
    override val workspaceCreationProperties: Optional[
      zio.aws.workspaces.model.DefaultWorkspaceCreationProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workspaceCreationProperties())
      .map(value =>
        zio.aws.workspaces.model.DefaultWorkspaceCreationProperties.wrap(value)
      )
    override val ipGroupIds: Optional[List[IpGroupId]] = zio.aws.core.internal
      .optionalFromNullable(impl.ipGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.primitives.IpGroupId(item)
        }.toList
      )
    override val workspaceAccessProperties: Optional[
      zio.aws.workspaces.model.WorkspaceAccessProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workspaceAccessProperties())
      .map(value =>
        zio.aws.workspaces.model.WorkspaceAccessProperties.wrap(value)
      )
    override val tenancy: Optional[zio.aws.workspaces.model.Tenancy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tenancy())
        .map(value => zio.aws.workspaces.model.Tenancy.wrap(value))
    override val selfservicePermissions
        : Optional[zio.aws.workspaces.model.SelfservicePermissions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selfservicePermissions())
        .map(value =>
          zio.aws.workspaces.model.SelfservicePermissions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceDirectory
  ): zio.aws.workspaces.model.WorkspaceDirectory.ReadOnly = new Wrapper(impl)
}
