package zio.aws.workspaces.model
import scala.jdk.CollectionConverters.*
sealed trait TargetWorkspaceState {
  def unwrap
      : software.amazon.awssdk.services.workspaces.model.TargetWorkspaceState
}
object TargetWorkspaceState {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.TargetWorkspaceState
  ): zio.aws.workspaces.model.TargetWorkspaceState = value match {
    case software.amazon.awssdk.services.workspaces.model.TargetWorkspaceState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.TargetWorkspaceState.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.workspaces.model.TargetWorkspaceState.ADMIN_MAINTENANCE =>
      val r = ADMIN_MAINTENANCE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.TargetWorkspaceState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.TargetWorkspaceState =
      software.amazon.awssdk.services.workspaces.model.TargetWorkspaceState.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE extends zio.aws.workspaces.model.TargetWorkspaceState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.TargetWorkspaceState =
      software.amazon.awssdk.services.workspaces.model.TargetWorkspaceState.AVAILABLE
  }
  case object ADMIN_MAINTENANCE
      extends zio.aws.workspaces.model.TargetWorkspaceState {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.TargetWorkspaceState =
      software.amazon.awssdk.services.workspaces.model.TargetWorkspaceState.ADMIN_MAINTENANCE
  }
}
