package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OperatingSystem(
    `type`: Optional[zio.aws.workspaces.model.OperatingSystemType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.OperatingSystem = {
    import OperatingSystem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.OperatingSystem
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.OperatingSystem.ReadOnly =
    zio.aws.workspaces.model.OperatingSystem.wrap(buildAwsValue())
}
object OperatingSystem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.OperatingSystem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.OperatingSystem =
      zio.aws.workspaces.model.OperatingSystem(`type`.map(value => value))
    def `type`: Optional[zio.aws.workspaces.model.OperatingSystemType]
    def getType
        : ZIO[Any, AwsError, zio.aws.workspaces.model.OperatingSystemType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.OperatingSystem
  ) extends zio.aws.workspaces.model.OperatingSystem.ReadOnly {
    override val `type`
        : Optional[zio.aws.workspaces.model.OperatingSystemType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.workspaces.model.OperatingSystemType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.OperatingSystem
  ): zio.aws.workspaces.model.OperatingSystem.ReadOnly = new Wrapper(impl)
}
