package zio.aws.workspaces.model
import scala.jdk.CollectionConverters.*
sealed trait ModificationStateEnum {
  def unwrap
      : software.amazon.awssdk.services.workspaces.model.ModificationStateEnum
}
object ModificationStateEnum {
  def wrap(
      value: software.amazon.awssdk.services.workspaces.model.ModificationStateEnum
  ): zio.aws.workspaces.model.ModificationStateEnum = value match {
    case software.amazon.awssdk.services.workspaces.model.ModificationStateEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspaces.model.ModificationStateEnum.UPDATE_INITIATED =>
      val r = UPDATE_INITIATED
      r
    case software.amazon.awssdk.services.workspaces.model.ModificationStateEnum.UPDATE_IN_PROGRESS =>
      val r = UPDATE_IN_PROGRESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspaces.model.ModificationStateEnum {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ModificationStateEnum =
      software.amazon.awssdk.services.workspaces.model.ModificationStateEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object UPDATE_INITIATED
      extends zio.aws.workspaces.model.ModificationStateEnum {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ModificationStateEnum =
      software.amazon.awssdk.services.workspaces.model.ModificationStateEnum.UPDATE_INITIATED
  }
  case object UPDATE_IN_PROGRESS
      extends zio.aws.workspaces.model.ModificationStateEnum {
    override def unwrap
        : software.amazon.awssdk.services.workspaces.model.ModificationStateEnum =
      software.amazon.awssdk.services.workspaces.model.ModificationStateEnum.UPDATE_IN_PROGRESS
  }
}
