package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.WorkspaceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MigrateWorkspaceResponse(
    sourceWorkspaceId: Optional[WorkspaceId] = Optional.Absent,
    targetWorkspaceId: Optional[WorkspaceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceResponse = {
    import MigrateWorkspaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceResponse
      .builder()
      .optionallyWith(
        sourceWorkspaceId.map(value =>
          WorkspaceId.unwrap(value): java.lang.String
        )
      )(_.sourceWorkspaceId)
      .optionallyWith(
        targetWorkspaceId.map(value =>
          WorkspaceId.unwrap(value): java.lang.String
        )
      )(_.targetWorkspaceId)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.MigrateWorkspaceResponse.ReadOnly =
    zio.aws.workspaces.model.MigrateWorkspaceResponse.wrap(buildAwsValue())
}
object MigrateWorkspaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.MigrateWorkspaceResponse =
      zio.aws.workspaces.model.MigrateWorkspaceResponse(
        sourceWorkspaceId.map(value => value),
        targetWorkspaceId.map(value => value)
      )
    def sourceWorkspaceId: Optional[WorkspaceId]
    def targetWorkspaceId: Optional[WorkspaceId]
    def getSourceWorkspaceId: ZIO[Any, AwsError, WorkspaceId] =
      AwsError.unwrapOptionField("sourceWorkspaceId", sourceWorkspaceId)
    def getTargetWorkspaceId: ZIO[Any, AwsError, WorkspaceId] =
      AwsError.unwrapOptionField("targetWorkspaceId", targetWorkspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceResponse
  ) extends zio.aws.workspaces.model.MigrateWorkspaceResponse.ReadOnly {
    override val sourceWorkspaceId: Optional[WorkspaceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceWorkspaceId())
        .map(value => zio.aws.workspaces.model.primitives.WorkspaceId(value))
    override val targetWorkspaceId: Optional[WorkspaceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetWorkspaceId())
        .map(value => zio.aws.workspaces.model.primitives.WorkspaceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceResponse
  ): zio.aws.workspaces.model.MigrateWorkspaceResponse.ReadOnly = new Wrapper(
    impl
  )
}
