package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  IosLogo,
  ClientLoginMessage,
  ClientEmail,
  ClientUrl,
  ClientLocale,
  Ios2XLogo,
  Ios3XLogo
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IosImportClientBrandingAttributes(
    logo: Optional[IosLogo] = Optional.Absent,
    logo2x: Optional[Ios2XLogo] = Optional.Absent,
    logo3x: Optional[Ios3XLogo] = Optional.Absent,
    supportEmail: Optional[ClientEmail] = Optional.Absent,
    supportLink: Optional[ClientUrl] = Optional.Absent,
    forgotPasswordLink: Optional[ClientUrl] = Optional.Absent,
    loginMessage: Optional[Map[ClientLocale, ClientLoginMessage]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.IosImportClientBrandingAttributes = {
    import IosImportClientBrandingAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.IosImportClientBrandingAttributes
      .builder()
      .optionallyWith(
        logo.map(value =>
          software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
            value.toArray[Byte]
          )
        )
      )(_.logo)
      .optionallyWith(
        logo2x.map(value =>
          software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
            value.toArray[Byte]
          )
        )
      )(_.logo2x)
      .optionallyWith(
        logo3x.map(value =>
          software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
            value.toArray[Byte]
          )
        )
      )(_.logo3x)
      .optionallyWith(
        supportEmail.map(value => ClientEmail.unwrap(value): java.lang.String)
      )(_.supportEmail)
      .optionallyWith(
        supportLink.map(value => ClientUrl.unwrap(value): java.lang.String)
      )(_.supportLink)
      .optionallyWith(
        forgotPasswordLink.map(value =>
          ClientUrl.unwrap(value): java.lang.String
        )
      )(_.forgotPasswordLink)
      .optionallyWith(
        loginMessage.map(value =>
          value
            .map({ case (key, value) =>
              (ClientLocale
                .unwrap(key): java.lang.String) -> (ClientLoginMessage
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.loginMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.IosImportClientBrandingAttributes.ReadOnly =
    zio.aws.workspaces.model.IosImportClientBrandingAttributes
      .wrap(buildAwsValue())
}
object IosImportClientBrandingAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.IosImportClientBrandingAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.IosImportClientBrandingAttributes =
      zio.aws.workspaces.model.IosImportClientBrandingAttributes(
        logo.map(value => value),
        logo2x.map(value => value),
        logo3x.map(value => value),
        supportEmail.map(value => value),
        supportLink.map(value => value),
        forgotPasswordLink.map(value => value),
        loginMessage.map(value => value)
      )
    def logo: Optional[IosLogo]
    def logo2x: Optional[Ios2XLogo]
    def logo3x: Optional[Ios3XLogo]
    def supportEmail: Optional[ClientEmail]
    def supportLink: Optional[ClientUrl]
    def forgotPasswordLink: Optional[ClientUrl]
    def loginMessage: Optional[Map[ClientLocale, ClientLoginMessage]]
    def getLogo: ZIO[Any, AwsError, IosLogo] =
      AwsError.unwrapOptionField("logo", logo)
    def getLogo2x: ZIO[Any, AwsError, Ios2XLogo] =
      AwsError.unwrapOptionField("logo2x", logo2x)
    def getLogo3x: ZIO[Any, AwsError, Ios3XLogo] =
      AwsError.unwrapOptionField("logo3x", logo3x)
    def getSupportEmail: ZIO[Any, AwsError, ClientEmail] =
      AwsError.unwrapOptionField("supportEmail", supportEmail)
    def getSupportLink: ZIO[Any, AwsError, ClientUrl] =
      AwsError.unwrapOptionField("supportLink", supportLink)
    def getForgotPasswordLink: ZIO[Any, AwsError, ClientUrl] =
      AwsError.unwrapOptionField("forgotPasswordLink", forgotPasswordLink)
    def getLoginMessage
        : ZIO[Any, AwsError, Map[ClientLocale, ClientLoginMessage]] =
      AwsError.unwrapOptionField("loginMessage", loginMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.IosImportClientBrandingAttributes
  ) extends zio.aws.workspaces.model.IosImportClientBrandingAttributes.ReadOnly {
    override val logo: Optional[IosLogo] = zio.aws.core.internal
      .optionalFromNullable(impl.logo())
      .map(value =>
        zio.aws.workspaces.model.primitives
          .IosLogo(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val logo2x: Optional[Ios2XLogo] = zio.aws.core.internal
      .optionalFromNullable(impl.logo2x())
      .map(value =>
        zio.aws.workspaces.model.primitives
          .Ios2XLogo(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val logo3x: Optional[Ios3XLogo] = zio.aws.core.internal
      .optionalFromNullable(impl.logo3x())
      .map(value =>
        zio.aws.workspaces.model.primitives
          .Ios3XLogo(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val supportEmail: Optional[ClientEmail] = zio.aws.core.internal
      .optionalFromNullable(impl.supportEmail())
      .map(value => zio.aws.workspaces.model.primitives.ClientEmail(value))
    override val supportLink: Optional[ClientUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.supportLink())
      .map(value => zio.aws.workspaces.model.primitives.ClientUrl(value))
    override val forgotPasswordLink: Optional[ClientUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.forgotPasswordLink())
      .map(value => zio.aws.workspaces.model.primitives.ClientUrl(value))
    override val loginMessage: Optional[Map[ClientLocale, ClientLoginMessage]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loginMessage())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.workspaces.model.primitives.ClientLocale(
                key
              ) -> zio.aws.workspaces.model.primitives.ClientLoginMessage(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.IosImportClientBrandingAttributes
  ): zio.aws.workspaces.model.IosImportClientBrandingAttributes.ReadOnly =
    new Wrapper(impl)
}
