package zio.aws.workspaces.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.workspaces.model.primitives.{
  Limit,
  PaginationToken,
  WorkspaceImageId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspaceImagesRequest(
    imageIds: Optional[Iterable[WorkspaceImageId]] = Optional.Absent,
    imageType: Optional[zio.aws.workspaces.model.ImageType] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[Limit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest = {
    import DescribeWorkspaceImagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest
      .builder()
      .optionallyWith(
        imageIds.map(value =>
          value.map { item =>
            WorkspaceImageId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.imageIds)
      .optionallyWith(imageType.map(value => value.unwrap))(_.imageType)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => Limit.unwrap(value): Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeWorkspaceImagesRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeWorkspaceImagesRequest
      .wrap(buildAwsValue())
}
object DescribeWorkspaceImagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DescribeWorkspaceImagesRequest =
      zio.aws.workspaces.model.DescribeWorkspaceImagesRequest(
        imageIds.map(value => value),
        imageType.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def imageIds: Optional[List[WorkspaceImageId]]
    def imageType: Optional[zio.aws.workspaces.model.ImageType]
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[Limit]
    def getImageIds: ZIO[Any, AwsError, List[WorkspaceImageId]] =
      AwsError.unwrapOptionField("imageIds", imageIds)
    def getImageType: ZIO[Any, AwsError, zio.aws.workspaces.model.ImageType] =
      AwsError.unwrapOptionField("imageType", imageType)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest
  ) extends zio.aws.workspaces.model.DescribeWorkspaceImagesRequest.ReadOnly {
    override val imageIds: Optional[List[WorkspaceImageId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspaces.model.primitives.WorkspaceImageId(item)
          }.toList
        )
    override val imageType: Optional[zio.aws.workspaces.model.ImageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageType())
        .map(value => zio.aws.workspaces.model.ImageType.wrap(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
    override val maxResults: Optional[Limit] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.workspaces.model.primitives.Limit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest
  ): zio.aws.workspaces.model.DescribeWorkspaceImagesRequest.ReadOnly =
    new Wrapper(impl)
}
