package zio.aws.workspaces.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.workspaces.model.primitives.{
  Limit,
  PaginationToken,
  WorkspaceImageId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspaceImagePermissionsRequest(
    imageId: WorkspaceImageId,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[Limit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsRequest = {
    import DescribeWorkspaceImagePermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsRequest
      .builder()
      .imageId(WorkspaceImageId.unwrap(imageId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => Limit.unwrap(value): Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsRequest.ReadOnly =
    zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsRequest
      .wrap(buildAwsValue())
}
object DescribeWorkspaceImagePermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsRequest =
      zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsRequest(
        imageId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def imageId: WorkspaceImageId
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[Limit]
    def getImageId: ZIO[Any, Nothing, WorkspaceImageId] = ZIO.succeed(imageId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsRequest
  ) extends zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsRequest.ReadOnly {
    override val imageId: WorkspaceImageId =
      zio.aws.workspaces.model.primitives.WorkspaceImageId(impl.imageId())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
    override val maxResults: Optional[Limit] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.workspaces.model.primitives.Limit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsRequest
  ): zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsRequest.ReadOnly =
    new Wrapper(impl)
}
