package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{PaginationToken, ConnectionAliasId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeConnectionAliasPermissionsResponse(
    aliasId: Optional[ConnectionAliasId] = Optional.Absent,
    connectionAliasPermissions: Optional[
      Iterable[zio.aws.workspaces.model.ConnectionAliasPermission]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsResponse = {
    import DescribeConnectionAliasPermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsResponse
      .builder()
      .optionallyWith(
        aliasId.map(value => ConnectionAliasId.unwrap(value): java.lang.String)
      )(_.aliasId)
      .optionallyWith(
        connectionAliasPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connectionAliasPermissions)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse
      .wrap(buildAwsValue())
}
object DescribeConnectionAliasPermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse =
      zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse(
        aliasId.map(value => value),
        connectionAliasPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def aliasId: Optional[ConnectionAliasId]
    def connectionAliasPermissions: Optional[
      List[zio.aws.workspaces.model.ConnectionAliasPermission.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getAliasId: ZIO[Any, AwsError, ConnectionAliasId] =
      AwsError.unwrapOptionField("aliasId", aliasId)
    def getConnectionAliasPermissions: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.ConnectionAliasPermission.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "connectionAliasPermissions",
      connectionAliasPermissions
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsResponse
  ) extends zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse.ReadOnly {
    override val aliasId: Optional[ConnectionAliasId] = zio.aws.core.internal
      .optionalFromNullable(impl.aliasId())
      .map(value =>
        zio.aws.workspaces.model.primitives.ConnectionAliasId(value)
      )
    override val connectionAliasPermissions: Optional[
      List[zio.aws.workspaces.model.ConnectionAliasPermission.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionAliasPermissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.ConnectionAliasPermission.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsResponse
  ): zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse.ReadOnly =
    new Wrapper(impl)
}
