package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeAccountModificationsResponse(
    accountModifications: Optional[
      Iterable[zio.aws.workspaces.model.AccountModification]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsResponse = {
    import DescribeAccountModificationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsResponse
      .builder()
      .optionallyWith(
        accountModifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountModifications)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DescribeAccountModificationsResponse.ReadOnly =
    zio.aws.workspaces.model.DescribeAccountModificationsResponse
      .wrap(buildAwsValue())
}
object DescribeAccountModificationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspaces.model.DescribeAccountModificationsResponse =
      zio.aws.workspaces.model.DescribeAccountModificationsResponse(
        accountModifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def accountModifications
        : Optional[List[zio.aws.workspaces.model.AccountModification.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getAccountModifications: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.AccountModification.ReadOnly
    ]] =
      AwsError.unwrapOptionField("accountModifications", accountModifications)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsResponse
  ) extends zio.aws.workspaces.model.DescribeAccountModificationsResponse.ReadOnly {
    override val accountModifications: Optional[
      List[zio.aws.workspaces.model.AccountModification.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accountModifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.AccountModification.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.workspaces.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsResponse
  ): zio.aws.workspaces.model.DescribeAccountModificationsResponse.ReadOnly =
    new Wrapper(impl)
}
