package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.BundleId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteWorkspaceBundleRequest(
    bundleId: Optional[BundleId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceBundleRequest = {
    import DeleteWorkspaceBundleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceBundleRequest
      .builder()
      .optionallyWith(
        bundleId.map(value => BundleId.unwrap(value): java.lang.String)
      )(_.bundleId)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.DeleteWorkspaceBundleRequest.ReadOnly =
    zio.aws.workspaces.model.DeleteWorkspaceBundleRequest.wrap(buildAwsValue())
}
object DeleteWorkspaceBundleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceBundleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.DeleteWorkspaceBundleRequest =
      zio.aws.workspaces.model
        .DeleteWorkspaceBundleRequest(bundleId.map(value => value))
    def bundleId: Optional[BundleId]
    def getBundleId: ZIO[Any, AwsError, BundleId] =
      AwsError.unwrapOptionField("bundleId", bundleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceBundleRequest
  ) extends zio.aws.workspaces.model.DeleteWorkspaceBundleRequest.ReadOnly {
    override val bundleId: Optional[BundleId] = zio.aws.core.internal
      .optionalFromNullable(impl.bundleId())
      .map(value => zio.aws.workspaces.model.primitives.BundleId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceBundleRequest
  ): zio.aws.workspaces.model.DeleteWorkspaceBundleRequest.ReadOnly =
    new Wrapper(impl)
}
