package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.WorkspaceImageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CopyWorkspaceImageResponse(
    imageId: Optional[WorkspaceImageId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageResponse = {
    import CopyWorkspaceImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageResponse
      .builder()
      .optionallyWith(
        imageId.map(value => WorkspaceImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.CopyWorkspaceImageResponse.ReadOnly =
    zio.aws.workspaces.model.CopyWorkspaceImageResponse.wrap(buildAwsValue())
}
object CopyWorkspaceImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.CopyWorkspaceImageResponse =
      zio.aws.workspaces.model
        .CopyWorkspaceImageResponse(imageId.map(value => value))
    def imageId: Optional[WorkspaceImageId]
    def getImageId: ZIO[Any, AwsError, WorkspaceImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageResponse
  ) extends zio.aws.workspaces.model.CopyWorkspaceImageResponse.ReadOnly {
    override val imageId: Optional[WorkspaceImageId] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.workspaces.model.primitives.WorkspaceImageId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageResponse
  ): zio.aws.workspaces.model.CopyWorkspaceImageResponse.ReadOnly = new Wrapper(
    impl
  )
}
