package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{NonEmptyString, ConnectionAliasId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AssociateConnectionAliasRequest(
    aliasId: ConnectionAliasId,
    resourceId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasRequest = {
    import AssociateConnectionAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasRequest
      .builder()
      .aliasId(ConnectionAliasId.unwrap(aliasId): java.lang.String)
      .resourceId(NonEmptyString.unwrap(resourceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspaces.model.AssociateConnectionAliasRequest.ReadOnly =
    zio.aws.workspaces.model.AssociateConnectionAliasRequest
      .wrap(buildAwsValue())
}
object AssociateConnectionAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.AssociateConnectionAliasRequest =
      zio.aws.workspaces.model
        .AssociateConnectionAliasRequest(aliasId, resourceId)
    def aliasId: ConnectionAliasId
    def resourceId: NonEmptyString
    def getAliasId: ZIO[Any, Nothing, ConnectionAliasId] = ZIO.succeed(aliasId)
    def getResourceId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasRequest
  ) extends zio.aws.workspaces.model.AssociateConnectionAliasRequest.ReadOnly {
    override val aliasId: ConnectionAliasId =
      zio.aws.workspaces.model.primitives.ConnectionAliasId(impl.aliasId())
    override val resourceId: NonEmptyString =
      zio.aws.workspaces.model.primitives.NonEmptyString(impl.resourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasRequest
  ): zio.aws.workspaces.model.AssociateConnectionAliasRequest.ReadOnly =
    new Wrapper(impl)
}
