package zio.aws.workspaces
import zio.aws.workspaces.model.{
  AssociateConnectionAliasRequest,
  AuthorizeIpRulesRequest,
  DescribeWorkspaceSnapshotsRequest,
  DescribeWorkspacesRequest,
  DescribeWorkspacesConnectionStatusRequest,
  DescribeWorkspaceImagesRequest,
  TerminateWorkspacesRequest,
  MigrateWorkspaceRequest,
  ModifyClientPropertiesRequest,
  CopyWorkspaceImageRequest,
  DeleteTagsRequest,
  ListAvailableManagementCidrRangesRequest,
  DescribeClientBrandingRequest,
  RebuildWorkspacesRequest,
  ModifyWorkspaceCreationPropertiesRequest,
  CreateWorkspacesRequest,
  RebootWorkspacesRequest,
  CreateIpGroupRequest,
  DescribeWorkspaceDirectoriesRequest,
  DescribeConnectClientAddInsRequest,
  DescribeAccountModificationsRequest,
  DescribeConnectionAliasPermissionsRequest,
  ModifyWorkspaceAccessPropertiesRequest,
  DeleteConnectionAliasRequest,
  CreateWorkspaceBundleRequest,
  StartWorkspacesRequest,
  CreateTagsRequest,
  ModifyAccountRequest,
  ModifyWorkspacePropertiesRequest,
  DeleteIpGroupRequest,
  DeleteWorkspaceBundleRequest,
  DescribeConnectionAliasesRequest,
  DeleteConnectClientAddInRequest,
  ImportClientBrandingRequest,
  UpdateConnectClientAddInRequest,
  ImportWorkspaceImageRequest,
  DeleteWorkspaceImageRequest,
  StopWorkspacesRequest,
  DisassociateIpGroupsRequest,
  UpdateRulesOfIpGroupRequest,
  RegisterWorkspaceDirectoryRequest,
  UpdateWorkspaceBundleRequest,
  DescribeWorkspaceImagePermissionsRequest,
  RestoreWorkspaceRequest,
  AssociateIpGroupsRequest,
  DeleteClientBrandingRequest,
  DisassociateConnectionAliasRequest,
  UpdateConnectionAliasPermissionRequest,
  DescribeTagsRequest,
  DescribeIpGroupsRequest,
  CreateUpdatedWorkspaceImageRequest,
  DescribeWorkspaceBundlesRequest,
  DeregisterWorkspaceDirectoryRequest,
  ModifyWorkspaceStateRequest,
  UpdateWorkspaceImagePermissionRequest,
  DescribeClientPropertiesRequest,
  CreateConnectionAliasRequest,
  ModifySelfservicePermissionsRequest,
  CreateConnectClientAddInRequest,
  DescribeAccountRequest,
  RevokeIpRulesRequest
}
import zio.aws.workspaces.model.RegisterWorkspaceDirectoryResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.workspaces.{
  WorkSpacesAsyncClientBuilder,
  WorkSpacesAsyncClient
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.workspaces.model.{
  AssociateIpGroupsResponse,
  AccountModification,
  WorkspaceConnectionStatus,
  RebuildWorkspacesResponse,
  DescribeConnectionAliasPermissionsResponse,
  DeleteClientBrandingResponse,
  ModifyWorkspaceAccessPropertiesResponse,
  Workspace,
  CopyWorkspaceImageResponse,
  UpdateConnectionAliasPermissionResponse,
  DescribeWorkspaceSnapshotsResponse,
  CreateWorkspacesResponse,
  DescribeWorkspacesConnectionStatusResponse,
  DeleteWorkspaceBundleResponse,
  DeregisterWorkspaceDirectoryResponse,
  RestoreWorkspaceResponse,
  DeleteTagsResponse,
  DescribeClientPropertiesResponse,
  WorkspaceBundle,
  DescribeConnectionAliasesResponse,
  StopWorkspacesResponse,
  ModifySelfservicePermissionsResponse,
  WorkspacesIpGroup,
  RevokeIpRulesResponse,
  CreateIpGroupResponse,
  DeleteConnectClientAddInResponse,
  AuthorizeIpRulesResponse,
  DescribeIpGroupsResponse,
  ListAvailableManagementCidrRangesResponse,
  DescribeWorkspaceBundlesResponse,
  DescribeConnectClientAddInsResponse,
  DescribeAccountResponse,
  RebootWorkspacesResponse,
  UpdateWorkspaceBundleResponse,
  ModifyWorkspaceCreationPropertiesResponse,
  UpdateRulesOfIpGroupResponse,
  DescribeWorkspacesResponse,
  DeleteConnectionAliasResponse,
  DescribeClientBrandingResponse,
  ImportClientBrandingResponse,
  DeleteWorkspaceImageResponse,
  CreateConnectClientAddInResponse,
  MigrateWorkspaceResponse,
  ModifyClientPropertiesResponse,
  UpdateConnectClientAddInResponse,
  DeleteIpGroupResponse,
  DescribeWorkspaceImagesResponse,
  StartWorkspacesResponse,
  DescribeWorkspaceDirectoriesResponse,
  ModifyAccountResponse,
  ModifyWorkspacePropertiesResponse,
  DescribeAccountModificationsResponse,
  DescribeWorkspaceImagePermissionsResponse,
  CreateWorkspaceBundleResponse,
  ImagePermission,
  ImportWorkspaceImageResponse,
  WorkspaceImage,
  UpdateWorkspaceImagePermissionResponse,
  AssociateConnectionAliasResponse,
  WorkspaceDirectory,
  TerminateWorkspacesResponse,
  DisassociateConnectionAliasResponse,
  ConnectionAlias,
  ConnectionAliasPermission,
  ModifyWorkspaceStateResponse,
  RegisterWorkspaceDirectoryResponse,
  DescribeTagsResponse,
  ConnectClientAddIn,
  DisassociateIpGroupsResponse,
  CreateConnectionAliasResponse,
  CreateUpdatedWorkspaceImageResponse,
  CreateTagsResponse
}
import zio.aws.workspaces.model.primitives.DedicatedTenancyManagementCidrRange
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait WorkSpaces extends AspectSupport[WorkSpaces] {
  val api: WorkSpacesAsyncClient
  def modifyWorkspaceProperties(request: ModifyWorkspacePropertiesRequest): IO[
    AwsError,
    zio.aws.workspaces.model.ModifyWorkspacePropertiesResponse.ReadOnly
  ]
  def describeTags(
      request: DescribeTagsRequest
  ): IO[AwsError, zio.aws.workspaces.model.DescribeTagsResponse.ReadOnly]
  def updateRulesOfIpGroup(request: UpdateRulesOfIpGroupRequest): IO[
    AwsError,
    zio.aws.workspaces.model.UpdateRulesOfIpGroupResponse.ReadOnly
  ]
  def updateConnectClientAddIn(request: UpdateConnectClientAddInRequest): IO[
    AwsError,
    zio.aws.workspaces.model.UpdateConnectClientAddInResponse.ReadOnly
  ]
  def deregisterWorkspaceDirectory(
      request: DeregisterWorkspaceDirectoryRequest
  ): IO[
    AwsError,
    zio.aws.workspaces.model.DeregisterWorkspaceDirectoryResponse.ReadOnly
  ]
  def deleteIpGroup(
      request: DeleteIpGroupRequest
  ): IO[AwsError, zio.aws.workspaces.model.DeleteIpGroupResponse.ReadOnly]
  def deleteClientBranding(request: DeleteClientBrandingRequest): IO[
    AwsError,
    zio.aws.workspaces.model.DeleteClientBrandingResponse.ReadOnly
  ]
  def describeConnectionAliases(
      request: DescribeConnectionAliasesRequest
  ): ZStream[Any, AwsError, zio.aws.workspaces.model.ConnectionAlias.ReadOnly]
  def describeConnectionAliasesPaginated(
      request: DescribeConnectionAliasesRequest
  ): IO[
    AwsError,
    zio.aws.workspaces.model.DescribeConnectionAliasesResponse.ReadOnly
  ]
  def modifyAccount(
      request: ModifyAccountRequest
  ): IO[AwsError, zio.aws.workspaces.model.ModifyAccountResponse.ReadOnly]
  def describeAccountModifications(
      request: DescribeAccountModificationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.workspaces.model.AccountModification.ReadOnly
  ]
  def describeAccountModificationsPaginated(
      request: DescribeAccountModificationsRequest
  ): IO[
    AwsError,
    zio.aws.workspaces.model.DescribeAccountModificationsResponse.ReadOnly
  ]
  def describeWorkspaceBundles(
      request: DescribeWorkspaceBundlesRequest
  ): ZStream[Any, AwsError, zio.aws.workspaces.model.WorkspaceBundle.ReadOnly]
  def describeWorkspaceBundlesPaginated(
      request: DescribeWorkspaceBundlesRequest
  ): IO[
    AwsError,
    zio.aws.workspaces.model.DescribeWorkspaceBundlesResponse.ReadOnly
  ]
  def startWorkspaces(
      request: StartWorkspacesRequest
  ): IO[AwsError, zio.aws.workspaces.model.StartWorkspacesResponse.ReadOnly]
  def describeClientBranding(request: DescribeClientBrandingRequest): IO[
    AwsError,
    zio.aws.workspaces.model.DescribeClientBrandingResponse.ReadOnly
  ]
  def modifySelfservicePermissions(
      request: ModifySelfservicePermissionsRequest
  ): IO[
    AwsError,
    zio.aws.workspaces.model.ModifySelfservicePermissionsResponse.ReadOnly
  ]
  def describeWorkspacesConnectionStatus(
      request: DescribeWorkspacesConnectionStatusRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.workspaces.model.WorkspaceConnectionStatus.ReadOnly
  ]
  def describeWorkspacesConnectionStatusPaginated(
      request: DescribeWorkspacesConnectionStatusRequest
  ): IO[
    AwsError,
    zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusResponse.ReadOnly
  ]
  def modifyWorkspaceState(request: ModifyWorkspaceStateRequest): IO[
    AwsError,
    zio.aws.workspaces.model.ModifyWorkspaceStateResponse.ReadOnly
  ]
  def deleteConnectionAlias(request: DeleteConnectionAliasRequest): IO[
    AwsError,
    zio.aws.workspaces.model.DeleteConnectionAliasResponse.ReadOnly
  ]
  def modifyWorkspaceAccessProperties(
      request: ModifyWorkspaceAccessPropertiesRequest
  ): IO[
    AwsError,
    zio.aws.workspaces.model.ModifyWorkspaceAccessPropertiesResponse.ReadOnly
  ]
  def createConnectionAlias(request: CreateConnectionAliasRequest): IO[
    AwsError,
    zio.aws.workspaces.model.CreateConnectionAliasResponse.ReadOnly
  ]
  def revokeIpRules(
      request: RevokeIpRulesRequest
  ): IO[AwsError, zio.aws.workspaces.model.RevokeIpRulesResponse.ReadOnly]
  def restoreWorkspace(
      request: RestoreWorkspaceRequest
  ): IO[AwsError, zio.aws.workspaces.model.RestoreWorkspaceResponse.ReadOnly]
  def describeConnectionAliasPermissions(
      request: DescribeConnectionAliasPermissionsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse.ReadOnly,
    zio.aws.workspaces.model.ConnectionAliasPermission.ReadOnly
  ]]
  def describeConnectionAliasPermissionsPaginated(
      request: DescribeConnectionAliasPermissionsRequest
  ): IO[
    AwsError,
    zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse.ReadOnly
  ]
  def migrateWorkspace(
      request: MigrateWorkspaceRequest
  ): IO[AwsError, zio.aws.workspaces.model.MigrateWorkspaceResponse.ReadOnly]
  def updateWorkspaceImagePermission(
      request: UpdateWorkspaceImagePermissionRequest
  ): IO[
    AwsError,
    zio.aws.workspaces.model.UpdateWorkspaceImagePermissionResponse.ReadOnly
  ]
  def listAvailableManagementCidrRanges(
      request: ListAvailableManagementCidrRangesRequest
  ): ZStream[Any, AwsError, DedicatedTenancyManagementCidrRange]
  def listAvailableManagementCidrRangesPaginated(
      request: ListAvailableManagementCidrRangesRequest
  ): IO[
    AwsError,
    zio.aws.workspaces.model.ListAvailableManagementCidrRangesResponse.ReadOnly
  ]
  def authorizeIpRules(
      request: AuthorizeIpRulesRequest
  ): IO[AwsError, zio.aws.workspaces.model.AuthorizeIpRulesResponse.ReadOnly]
  def describeWorkspaceImagePermissions(
      request: DescribeWorkspaceImagePermissionsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse.ReadOnly,
    zio.aws.workspaces.model.ImagePermission.ReadOnly
  ]]
  def describeWorkspaceImagePermissionsPaginated(
      request: DescribeWorkspaceImagePermissionsRequest
  ): IO[
    AwsError,
    zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse.ReadOnly
  ]
  def describeAccount(
      request: DescribeAccountRequest
  ): IO[AwsError, zio.aws.workspaces.model.DescribeAccountResponse.ReadOnly]
  def createIpGroup(
      request: CreateIpGroupRequest
  ): IO[AwsError, zio.aws.workspaces.model.CreateIpGroupResponse.ReadOnly]
  def updateWorkspaceBundle(request: UpdateWorkspaceBundleRequest): IO[
    AwsError,
    zio.aws.workspaces.model.UpdateWorkspaceBundleResponse.ReadOnly
  ]
  def createWorkspaceBundle(request: CreateWorkspaceBundleRequest): IO[
    AwsError,
    zio.aws.workspaces.model.CreateWorkspaceBundleResponse.ReadOnly
  ]
  def importWorkspaceImage(request: ImportWorkspaceImageRequest): IO[
    AwsError,
    zio.aws.workspaces.model.ImportWorkspaceImageResponse.ReadOnly
  ]
  def registerWorkspaceDirectory(
      request: RegisterWorkspaceDirectoryRequest
  ): IO[AwsError, ReadOnly]
  def associateIpGroups(
      request: AssociateIpGroupsRequest
  ): IO[AwsError, zio.aws.workspaces.model.AssociateIpGroupsResponse.ReadOnly]
  def createConnectClientAddIn(request: CreateConnectClientAddInRequest): IO[
    AwsError,
    zio.aws.workspaces.model.CreateConnectClientAddInResponse.ReadOnly
  ]
  def modifyClientProperties(request: ModifyClientPropertiesRequest): IO[
    AwsError,
    zio.aws.workspaces.model.ModifyClientPropertiesResponse.ReadOnly
  ]
  def disassociateConnectionAlias(
      request: DisassociateConnectionAliasRequest
  ): IO[
    AwsError,
    zio.aws.workspaces.model.DisassociateConnectionAliasResponse.ReadOnly
  ]
  def stopWorkspaces(
      request: StopWorkspacesRequest
  ): IO[AwsError, zio.aws.workspaces.model.StopWorkspacesResponse.ReadOnly]
  def describeWorkspaces(
      request: DescribeWorkspacesRequest
  ): ZStream[Any, AwsError, zio.aws.workspaces.model.Workspace.ReadOnly]
  def describeWorkspacesPaginated(
      request: DescribeWorkspacesRequest
  ): IO[AwsError, zio.aws.workspaces.model.DescribeWorkspacesResponse.ReadOnly]
  def rebootWorkspaces(
      request: RebootWorkspacesRequest
  ): IO[AwsError, zio.aws.workspaces.model.RebootWorkspacesResponse.ReadOnly]
  def describeWorkspaceDirectories(
      request: DescribeWorkspaceDirectoriesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.workspaces.model.WorkspaceDirectory.ReadOnly
  ]
  def describeWorkspaceDirectoriesPaginated(
      request: DescribeWorkspaceDirectoriesRequest
  ): IO[
    AwsError,
    zio.aws.workspaces.model.DescribeWorkspaceDirectoriesResponse.ReadOnly
  ]
  def modifyWorkspaceCreationProperties(
      request: ModifyWorkspaceCreationPropertiesRequest
  ): IO[
    AwsError,
    zio.aws.workspaces.model.ModifyWorkspaceCreationPropertiesResponse.ReadOnly
  ]
  def describeWorkspaceSnapshots(
      request: DescribeWorkspaceSnapshotsRequest
  ): IO[
    AwsError,
    zio.aws.workspaces.model.DescribeWorkspaceSnapshotsResponse.ReadOnly
  ]
  def describeIpGroups(
      request: DescribeIpGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.workspaces.model.WorkspacesIpGroup.ReadOnly]
  def describeIpGroupsPaginated(
      request: DescribeIpGroupsRequest
  ): IO[AwsError, zio.aws.workspaces.model.DescribeIpGroupsResponse.ReadOnly]
  def createUpdatedWorkspaceImage(
      request: CreateUpdatedWorkspaceImageRequest
  ): IO[
    AwsError,
    zio.aws.workspaces.model.CreateUpdatedWorkspaceImageResponse.ReadOnly
  ]
  def terminateWorkspaces(
      request: TerminateWorkspacesRequest
  ): IO[AwsError, zio.aws.workspaces.model.TerminateWorkspacesResponse.ReadOnly]
  def copyWorkspaceImage(
      request: CopyWorkspaceImageRequest
  ): IO[AwsError, zio.aws.workspaces.model.CopyWorkspaceImageResponse.ReadOnly]
  def associateConnectionAlias(request: AssociateConnectionAliasRequest): IO[
    AwsError,
    zio.aws.workspaces.model.AssociateConnectionAliasResponse.ReadOnly
  ]
  def rebuildWorkspaces(
      request: RebuildWorkspacesRequest
  ): IO[AwsError, zio.aws.workspaces.model.RebuildWorkspacesResponse.ReadOnly]
  def deleteTags(
      request: DeleteTagsRequest
  ): IO[AwsError, zio.aws.workspaces.model.DeleteTagsResponse.ReadOnly]
  def describeWorkspaceImages(
      request: DescribeWorkspaceImagesRequest
  ): ZStream[Any, AwsError, zio.aws.workspaces.model.WorkspaceImage.ReadOnly]
  def describeWorkspaceImagesPaginated(
      request: DescribeWorkspaceImagesRequest
  ): IO[
    AwsError,
    zio.aws.workspaces.model.DescribeWorkspaceImagesResponse.ReadOnly
  ]
  def createWorkspaces(
      request: CreateWorkspacesRequest
  ): IO[AwsError, zio.aws.workspaces.model.CreateWorkspacesResponse.ReadOnly]
  def deleteWorkspaceImage(request: DeleteWorkspaceImageRequest): IO[
    AwsError,
    zio.aws.workspaces.model.DeleteWorkspaceImageResponse.ReadOnly
  ]
  def deleteConnectClientAddIn(request: DeleteConnectClientAddInRequest): IO[
    AwsError,
    zio.aws.workspaces.model.DeleteConnectClientAddInResponse.ReadOnly
  ]
  def importClientBranding(request: ImportClientBrandingRequest): IO[
    AwsError,
    zio.aws.workspaces.model.ImportClientBrandingResponse.ReadOnly
  ]
  def deleteWorkspaceBundle(request: DeleteWorkspaceBundleRequest): IO[
    AwsError,
    zio.aws.workspaces.model.DeleteWorkspaceBundleResponse.ReadOnly
  ]
  def describeConnectClientAddIns(
      request: DescribeConnectClientAddInsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.workspaces.model.ConnectClientAddIn.ReadOnly
  ]
  def describeConnectClientAddInsPaginated(
      request: DescribeConnectClientAddInsRequest
  ): IO[
    AwsError,
    zio.aws.workspaces.model.DescribeConnectClientAddInsResponse.ReadOnly
  ]
  def disassociateIpGroups(request: DisassociateIpGroupsRequest): IO[
    AwsError,
    zio.aws.workspaces.model.DisassociateIpGroupsResponse.ReadOnly
  ]
  def describeClientProperties(request: DescribeClientPropertiesRequest): IO[
    AwsError,
    zio.aws.workspaces.model.DescribeClientPropertiesResponse.ReadOnly
  ]
  def updateConnectionAliasPermission(
      request: UpdateConnectionAliasPermissionRequest
  ): IO[
    AwsError,
    zio.aws.workspaces.model.UpdateConnectionAliasPermissionResponse.ReadOnly
  ]
  def createTags(
      request: CreateTagsRequest
  ): IO[AwsError, zio.aws.workspaces.model.CreateTagsResponse.ReadOnly]
}
object WorkSpaces {
  val live: ZLayer[AwsConfig, java.lang.Throwable, WorkSpaces] = customized(
    identity
  )
  def customized(
      customization: WorkSpacesAsyncClientBuilder => WorkSpacesAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, WorkSpaces] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: WorkSpacesAsyncClientBuilder => WorkSpacesAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, WorkSpaces] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = WorkSpacesAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[WorkSpacesAsyncClient, WorkSpacesAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[WorkSpacesAsyncClient, WorkSpacesAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new WorkSpacesImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class WorkSpacesImpl[R](
      override val api: WorkSpacesAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends WorkSpaces
      with AwsServiceBase[R] {
    override val serviceName: String = "WorkSpaces"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): WorkSpacesImpl[R1] = new WorkSpacesImpl(api, newAspect, r)
    def modifyWorkspaceProperties(
        request: ModifyWorkspacePropertiesRequest
    ): IO[
      AwsError,
      zio.aws.workspaces.model.ModifyWorkspacePropertiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesRequest,
      ModifyWorkspacePropertiesResponse
    ]("modifyWorkspaceProperties", api.modifyWorkspaceProperties)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.ModifyWorkspacePropertiesResponse.wrap)
      .provideEnvironment(r)
    def describeTags(
        request: DescribeTagsRequest
    ): IO[AwsError, zio.aws.workspaces.model.DescribeTagsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.workspaces.model.DescribeTagsRequest,
        DescribeTagsResponse
      ]("describeTags", api.describeTags)(request.buildAwsValue())
        .map(zio.aws.workspaces.model.DescribeTagsResponse.wrap)
        .provideEnvironment(r)
    def updateRulesOfIpGroup(request: UpdateRulesOfIpGroupRequest): IO[
      AwsError,
      zio.aws.workspaces.model.UpdateRulesOfIpGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupRequest,
      UpdateRulesOfIpGroupResponse
    ]("updateRulesOfIpGroup", api.updateRulesOfIpGroup)(request.buildAwsValue())
      .map(zio.aws.workspaces.model.UpdateRulesOfIpGroupResponse.wrap)
      .provideEnvironment(r)
    def updateConnectClientAddIn(request: UpdateConnectClientAddInRequest): IO[
      AwsError,
      zio.aws.workspaces.model.UpdateConnectClientAddInResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.UpdateConnectClientAddInRequest,
      UpdateConnectClientAddInResponse
    ]("updateConnectClientAddIn", api.updateConnectClientAddIn)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.UpdateConnectClientAddInResponse.wrap)
      .provideEnvironment(r)
    def deregisterWorkspaceDirectory(
        request: DeregisterWorkspaceDirectoryRequest
    ): IO[
      AwsError,
      zio.aws.workspaces.model.DeregisterWorkspaceDirectoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryRequest,
      DeregisterWorkspaceDirectoryResponse
    ]("deregisterWorkspaceDirectory", api.deregisterWorkspaceDirectory)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.DeregisterWorkspaceDirectoryResponse.wrap)
      .provideEnvironment(r)
    def deleteIpGroup(
        request: DeleteIpGroupRequest
    ): IO[AwsError, zio.aws.workspaces.model.DeleteIpGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.workspaces.model.DeleteIpGroupRequest,
        DeleteIpGroupResponse
      ]("deleteIpGroup", api.deleteIpGroup)(request.buildAwsValue())
        .map(zio.aws.workspaces.model.DeleteIpGroupResponse.wrap)
        .provideEnvironment(r)
    def deleteClientBranding(request: DeleteClientBrandingRequest): IO[
      AwsError,
      zio.aws.workspaces.model.DeleteClientBrandingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DeleteClientBrandingRequest,
      DeleteClientBrandingResponse
    ]("deleteClientBranding", api.deleteClientBranding)(request.buildAwsValue())
      .map(zio.aws.workspaces.model.DeleteClientBrandingResponse.wrap)
      .provideEnvironment(r)
    def describeConnectionAliases(
        request: DescribeConnectionAliasesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.workspaces.model.ConnectionAlias.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesRequest,
      DescribeConnectionAliasesResponse,
      ConnectionAlias
    ](
      "describeConnectionAliases",
      api.describeConnectionAliases,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.connectionAliases().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.workspaces.model.ConnectionAlias.wrap(item))
      .provideEnvironment(r)
    def describeConnectionAliasesPaginated(
        request: DescribeConnectionAliasesRequest
    ): IO[
      AwsError,
      zio.aws.workspaces.model.DescribeConnectionAliasesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesRequest,
      DescribeConnectionAliasesResponse
    ]("describeConnectionAliases", api.describeConnectionAliases)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.DescribeConnectionAliasesResponse.wrap)
      .provideEnvironment(r)
    def modifyAccount(
        request: ModifyAccountRequest
    ): IO[AwsError, zio.aws.workspaces.model.ModifyAccountResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.workspaces.model.ModifyAccountRequest,
        ModifyAccountResponse
      ]("modifyAccount", api.modifyAccount)(request.buildAwsValue())
        .map(zio.aws.workspaces.model.ModifyAccountResponse.wrap)
        .provideEnvironment(r)
    def describeAccountModifications(
        request: DescribeAccountModificationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.workspaces.model.AccountModification.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsRequest,
      DescribeAccountModificationsResponse,
      AccountModification
    ](
      "describeAccountModifications",
      api.describeAccountModifications,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.accountModifications().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.workspaces.model.AccountModification.wrap(item))
      .provideEnvironment(r)
    def describeAccountModificationsPaginated(
        request: DescribeAccountModificationsRequest
    ): IO[
      AwsError,
      zio.aws.workspaces.model.DescribeAccountModificationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsRequest,
      DescribeAccountModificationsResponse
    ]("describeAccountModifications", api.describeAccountModifications)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.DescribeAccountModificationsResponse.wrap)
      .provideEnvironment(r)
    def describeWorkspaceBundles(
        request: DescribeWorkspaceBundlesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.workspaces.model.WorkspaceBundle.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest,
      DescribeWorkspaceBundlesResponse,
      WorkspaceBundle
    ](
      "describeWorkspaceBundles",
      api.describeWorkspaceBundles,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.bundles().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.workspaces.model.WorkspaceBundle.wrap(item))
      .provideEnvironment(r)
    def describeWorkspaceBundlesPaginated(
        request: DescribeWorkspaceBundlesRequest
    ): IO[
      AwsError,
      zio.aws.workspaces.model.DescribeWorkspaceBundlesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest,
      DescribeWorkspaceBundlesResponse
    ]("describeWorkspaceBundles", api.describeWorkspaceBundles)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.DescribeWorkspaceBundlesResponse.wrap)
      .provideEnvironment(r)
    def startWorkspaces(
        request: StartWorkspacesRequest
    ): IO[AwsError, zio.aws.workspaces.model.StartWorkspacesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.workspaces.model.StartWorkspacesRequest,
        StartWorkspacesResponse
      ]("startWorkspaces", api.startWorkspaces)(request.buildAwsValue())
        .map(zio.aws.workspaces.model.StartWorkspacesResponse.wrap)
        .provideEnvironment(r)
    def describeClientBranding(request: DescribeClientBrandingRequest): IO[
      AwsError,
      zio.aws.workspaces.model.DescribeClientBrandingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingRequest,
      DescribeClientBrandingResponse
    ]("describeClientBranding", api.describeClientBranding)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.DescribeClientBrandingResponse.wrap)
      .provideEnvironment(r)
    def modifySelfservicePermissions(
        request: ModifySelfservicePermissionsRequest
    ): IO[
      AwsError,
      zio.aws.workspaces.model.ModifySelfservicePermissionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsRequest,
      ModifySelfservicePermissionsResponse
    ]("modifySelfservicePermissions", api.modifySelfservicePermissions)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.ModifySelfservicePermissionsResponse.wrap)
      .provideEnvironment(r)
    def describeWorkspacesConnectionStatus(
        request: DescribeWorkspacesConnectionStatusRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.workspaces.model.WorkspaceConnectionStatus.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest,
      DescribeWorkspacesConnectionStatusResponse,
      WorkspaceConnectionStatus
    ](
      "describeWorkspacesConnectionStatus",
      api.describeWorkspacesConnectionStatus,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.workspacesConnectionStatus().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.workspaces.model.WorkspaceConnectionStatus.wrap(item)
      )
      .provideEnvironment(r)
    def describeWorkspacesConnectionStatusPaginated(
        request: DescribeWorkspacesConnectionStatusRequest
    ): IO[
      AwsError,
      zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest,
      DescribeWorkspacesConnectionStatusResponse
    ](
      "describeWorkspacesConnectionStatus",
      api.describeWorkspacesConnectionStatus
    )(request.buildAwsValue())
      .map(
        zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusResponse.wrap
      )
      .provideEnvironment(r)
    def modifyWorkspaceState(request: ModifyWorkspaceStateRequest): IO[
      AwsError,
      zio.aws.workspaces.model.ModifyWorkspaceStateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateRequest,
      ModifyWorkspaceStateResponse
    ]("modifyWorkspaceState", api.modifyWorkspaceState)(request.buildAwsValue())
      .map(zio.aws.workspaces.model.ModifyWorkspaceStateResponse.wrap)
      .provideEnvironment(r)
    def deleteConnectionAlias(request: DeleteConnectionAliasRequest): IO[
      AwsError,
      zio.aws.workspaces.model.DeleteConnectionAliasResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DeleteConnectionAliasRequest,
      DeleteConnectionAliasResponse
    ]("deleteConnectionAlias", api.deleteConnectionAlias)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.DeleteConnectionAliasResponse.wrap)
      .provideEnvironment(r)
    def modifyWorkspaceAccessProperties(
        request: ModifyWorkspaceAccessPropertiesRequest
    ): IO[
      AwsError,
      zio.aws.workspaces.model.ModifyWorkspaceAccessPropertiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesRequest,
      ModifyWorkspaceAccessPropertiesResponse
    ]("modifyWorkspaceAccessProperties", api.modifyWorkspaceAccessProperties)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.ModifyWorkspaceAccessPropertiesResponse.wrap)
      .provideEnvironment(r)
    def createConnectionAlias(request: CreateConnectionAliasRequest): IO[
      AwsError,
      zio.aws.workspaces.model.CreateConnectionAliasResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasRequest,
      CreateConnectionAliasResponse
    ]("createConnectionAlias", api.createConnectionAlias)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.CreateConnectionAliasResponse.wrap)
      .provideEnvironment(r)
    def revokeIpRules(
        request: RevokeIpRulesRequest
    ): IO[AwsError, zio.aws.workspaces.model.RevokeIpRulesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.workspaces.model.RevokeIpRulesRequest,
        RevokeIpRulesResponse
      ]("revokeIpRules", api.revokeIpRules)(request.buildAwsValue())
        .map(zio.aws.workspaces.model.RevokeIpRulesResponse.wrap)
        .provideEnvironment(r)
    def restoreWorkspace(request: RestoreWorkspaceRequest): IO[
      AwsError,
      zio.aws.workspaces.model.RestoreWorkspaceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceRequest,
      RestoreWorkspaceResponse
    ]("restoreWorkspace", api.restoreWorkspace)(request.buildAwsValue())
      .map(zio.aws.workspaces.model.RestoreWorkspaceResponse.wrap)
      .provideEnvironment(r)
    def describeConnectionAliasPermissions(
        request: DescribeConnectionAliasPermissionsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse.ReadOnly,
      zio.aws.workspaces.model.ConnectionAliasPermission.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsRequest,
      DescribeConnectionAliasPermissionsResponse,
      ConnectionAliasPermission
    ](
      "describeConnectionAliasPermissions",
      api.describeConnectionAliasPermissions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.connectionAliasPermissions().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.workspaces.model.ConnectionAliasPermission.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeConnectionAliasPermissionsPaginated(
        request: DescribeConnectionAliasPermissionsRequest
    ): IO[
      AwsError,
      zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsRequest,
      DescribeConnectionAliasPermissionsResponse
    ](
      "describeConnectionAliasPermissions",
      api.describeConnectionAliasPermissions
    )(request.buildAwsValue())
      .map(
        zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse.wrap
      )
      .provideEnvironment(r)
    def migrateWorkspace(request: MigrateWorkspaceRequest): IO[
      AwsError,
      zio.aws.workspaces.model.MigrateWorkspaceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceRequest,
      MigrateWorkspaceResponse
    ]("migrateWorkspace", api.migrateWorkspace)(request.buildAwsValue())
      .map(zio.aws.workspaces.model.MigrateWorkspaceResponse.wrap)
      .provideEnvironment(r)
    def updateWorkspaceImagePermission(
        request: UpdateWorkspaceImagePermissionRequest
    ): IO[
      AwsError,
      zio.aws.workspaces.model.UpdateWorkspaceImagePermissionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceImagePermissionRequest,
      UpdateWorkspaceImagePermissionResponse
    ]("updateWorkspaceImagePermission", api.updateWorkspaceImagePermission)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.UpdateWorkspaceImagePermissionResponse.wrap)
      .provideEnvironment(r)
    def listAvailableManagementCidrRanges(
        request: ListAvailableManagementCidrRangesRequest
    ): ZStream[Any, AwsError, DedicatedTenancyManagementCidrRange] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesRequest,
        ListAvailableManagementCidrRangesResponse,
        java.lang.String
      ](
        "listAvailableManagementCidrRanges",
        api.listAvailableManagementCidrRanges,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.managementCidrRanges().asScala)
      )(request.buildAwsValue())
        .map(item =>
          zio.aws.workspaces.model.primitives
            .DedicatedTenancyManagementCidrRange(item)
        )
        .provideEnvironment(r)
    def listAvailableManagementCidrRangesPaginated(
        request: ListAvailableManagementCidrRangesRequest
    ): IO[
      AwsError,
      zio.aws.workspaces.model.ListAvailableManagementCidrRangesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesRequest,
      ListAvailableManagementCidrRangesResponse
    ](
      "listAvailableManagementCidrRanges",
      api.listAvailableManagementCidrRanges
    )(request.buildAwsValue())
      .map(
        zio.aws.workspaces.model.ListAvailableManagementCidrRangesResponse.wrap
      )
      .provideEnvironment(r)
    def authorizeIpRules(request: AuthorizeIpRulesRequest): IO[
      AwsError,
      zio.aws.workspaces.model.AuthorizeIpRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesRequest,
      AuthorizeIpRulesResponse
    ]("authorizeIpRules", api.authorizeIpRules)(request.buildAwsValue())
      .map(zio.aws.workspaces.model.AuthorizeIpRulesResponse.wrap)
      .provideEnvironment(r)
    def describeWorkspaceImagePermissions(
        request: DescribeWorkspaceImagePermissionsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse.ReadOnly,
      zio.aws.workspaces.model.ImagePermission.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsRequest,
      DescribeWorkspaceImagePermissionsResponse,
      ImagePermission
    ](
      "describeWorkspaceImagePermissions",
      api.describeWorkspaceImagePermissions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.imagePermissions().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse.wrap
          )
          .mapOutput(
            _.map(item => zio.aws.workspaces.model.ImagePermission.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeWorkspaceImagePermissionsPaginated(
        request: DescribeWorkspaceImagePermissionsRequest
    ): IO[
      AwsError,
      zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsRequest,
      DescribeWorkspaceImagePermissionsResponse
    ](
      "describeWorkspaceImagePermissions",
      api.describeWorkspaceImagePermissions
    )(request.buildAwsValue())
      .map(
        zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse.wrap
      )
      .provideEnvironment(r)
    def describeAccount(
        request: DescribeAccountRequest
    ): IO[AwsError, zio.aws.workspaces.model.DescribeAccountResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.workspaces.model.DescribeAccountRequest,
        DescribeAccountResponse
      ]("describeAccount", api.describeAccount)(request.buildAwsValue())
        .map(zio.aws.workspaces.model.DescribeAccountResponse.wrap)
        .provideEnvironment(r)
    def createIpGroup(
        request: CreateIpGroupRequest
    ): IO[AwsError, zio.aws.workspaces.model.CreateIpGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.workspaces.model.CreateIpGroupRequest,
        CreateIpGroupResponse
      ]("createIpGroup", api.createIpGroup)(request.buildAwsValue())
        .map(zio.aws.workspaces.model.CreateIpGroupResponse.wrap)
        .provideEnvironment(r)
    def updateWorkspaceBundle(request: UpdateWorkspaceBundleRequest): IO[
      AwsError,
      zio.aws.workspaces.model.UpdateWorkspaceBundleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleRequest,
      UpdateWorkspaceBundleResponse
    ]("updateWorkspaceBundle", api.updateWorkspaceBundle)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.UpdateWorkspaceBundleResponse.wrap)
      .provideEnvironment(r)
    def createWorkspaceBundle(request: CreateWorkspaceBundleRequest): IO[
      AwsError,
      zio.aws.workspaces.model.CreateWorkspaceBundleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleRequest,
      CreateWorkspaceBundleResponse
    ]("createWorkspaceBundle", api.createWorkspaceBundle)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.CreateWorkspaceBundleResponse.wrap)
      .provideEnvironment(r)
    def importWorkspaceImage(request: ImportWorkspaceImageRequest): IO[
      AwsError,
      zio.aws.workspaces.model.ImportWorkspaceImageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageRequest,
      ImportWorkspaceImageResponse
    ]("importWorkspaceImage", api.importWorkspaceImage)(request.buildAwsValue())
      .map(zio.aws.workspaces.model.ImportWorkspaceImageResponse.wrap)
      .provideEnvironment(r)
    def registerWorkspaceDirectory(
        request: RegisterWorkspaceDirectoryRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryRequest,
      RegisterWorkspaceDirectoryResponse
    ]("registerWorkspaceDirectory", api.registerWorkspaceDirectory)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.RegisterWorkspaceDirectoryResponse.wrap)
      .provideEnvironment(r)
    def associateIpGroups(request: AssociateIpGroupsRequest): IO[
      AwsError,
      zio.aws.workspaces.model.AssociateIpGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsRequest,
      AssociateIpGroupsResponse
    ]("associateIpGroups", api.associateIpGroups)(request.buildAwsValue())
      .map(zio.aws.workspaces.model.AssociateIpGroupsResponse.wrap)
      .provideEnvironment(r)
    def createConnectClientAddIn(request: CreateConnectClientAddInRequest): IO[
      AwsError,
      zio.aws.workspaces.model.CreateConnectClientAddInResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInRequest,
      CreateConnectClientAddInResponse
    ]("createConnectClientAddIn", api.createConnectClientAddIn)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.CreateConnectClientAddInResponse.wrap)
      .provideEnvironment(r)
    def modifyClientProperties(request: ModifyClientPropertiesRequest): IO[
      AwsError,
      zio.aws.workspaces.model.ModifyClientPropertiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesRequest,
      ModifyClientPropertiesResponse
    ]("modifyClientProperties", api.modifyClientProperties)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.ModifyClientPropertiesResponse.wrap)
      .provideEnvironment(r)
    def disassociateConnectionAlias(
        request: DisassociateConnectionAliasRequest
    ): IO[
      AwsError,
      zio.aws.workspaces.model.DisassociateConnectionAliasResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DisassociateConnectionAliasRequest,
      DisassociateConnectionAliasResponse
    ]("disassociateConnectionAlias", api.disassociateConnectionAlias)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.DisassociateConnectionAliasResponse.wrap)
      .provideEnvironment(r)
    def stopWorkspaces(
        request: StopWorkspacesRequest
    ): IO[AwsError, zio.aws.workspaces.model.StopWorkspacesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.workspaces.model.StopWorkspacesRequest,
        StopWorkspacesResponse
      ]("stopWorkspaces", api.stopWorkspaces)(request.buildAwsValue())
        .map(zio.aws.workspaces.model.StopWorkspacesResponse.wrap)
        .provideEnvironment(r)
    def describeWorkspaces(request: DescribeWorkspacesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.workspaces.model.Workspace.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest,
      DescribeWorkspacesResponse,
      Workspace
    ](
      "describeWorkspaces",
      api.describeWorkspaces,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.workspaces().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.workspaces.model.Workspace.wrap(item))
      .provideEnvironment(r)
    def describeWorkspacesPaginated(request: DescribeWorkspacesRequest): IO[
      AwsError,
      zio.aws.workspaces.model.DescribeWorkspacesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest,
      DescribeWorkspacesResponse
    ]("describeWorkspaces", api.describeWorkspaces)(request.buildAwsValue())
      .map(zio.aws.workspaces.model.DescribeWorkspacesResponse.wrap)
      .provideEnvironment(r)
    def rebootWorkspaces(request: RebootWorkspacesRequest): IO[
      AwsError,
      zio.aws.workspaces.model.RebootWorkspacesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.RebootWorkspacesRequest,
      RebootWorkspacesResponse
    ]("rebootWorkspaces", api.rebootWorkspaces)(request.buildAwsValue())
      .map(zio.aws.workspaces.model.RebootWorkspacesResponse.wrap)
      .provideEnvironment(r)
    def describeWorkspaceDirectories(
        request: DescribeWorkspaceDirectoriesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.workspaces.model.WorkspaceDirectory.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest,
      DescribeWorkspaceDirectoriesResponse,
      WorkspaceDirectory
    ](
      "describeWorkspaceDirectories",
      api.describeWorkspaceDirectories,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.directories().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.workspaces.model.WorkspaceDirectory.wrap(item))
      .provideEnvironment(r)
    def describeWorkspaceDirectoriesPaginated(
        request: DescribeWorkspaceDirectoriesRequest
    ): IO[
      AwsError,
      zio.aws.workspaces.model.DescribeWorkspaceDirectoriesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest,
      DescribeWorkspaceDirectoriesResponse
    ]("describeWorkspaceDirectories", api.describeWorkspaceDirectories)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.DescribeWorkspaceDirectoriesResponse.wrap)
      .provideEnvironment(r)
    def modifyWorkspaceCreationProperties(
        request: ModifyWorkspaceCreationPropertiesRequest
    ): IO[
      AwsError,
      zio.aws.workspaces.model.ModifyWorkspaceCreationPropertiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesRequest,
      ModifyWorkspaceCreationPropertiesResponse
    ](
      "modifyWorkspaceCreationProperties",
      api.modifyWorkspaceCreationProperties
    )(request.buildAwsValue())
      .map(
        zio.aws.workspaces.model.ModifyWorkspaceCreationPropertiesResponse.wrap
      )
      .provideEnvironment(r)
    def describeWorkspaceSnapshots(
        request: DescribeWorkspaceSnapshotsRequest
    ): IO[
      AwsError,
      zio.aws.workspaces.model.DescribeWorkspaceSnapshotsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsRequest,
      DescribeWorkspaceSnapshotsResponse
    ]("describeWorkspaceSnapshots", api.describeWorkspaceSnapshots)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.DescribeWorkspaceSnapshotsResponse.wrap)
      .provideEnvironment(r)
    def describeIpGroups(request: DescribeIpGroupsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.workspaces.model.WorkspacesIpGroup.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsRequest,
      DescribeIpGroupsResponse,
      WorkspacesIpGroup
    ](
      "describeIpGroups",
      api.describeIpGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.result().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.workspaces.model.WorkspacesIpGroup.wrap(item))
      .provideEnvironment(r)
    def describeIpGroupsPaginated(request: DescribeIpGroupsRequest): IO[
      AwsError,
      zio.aws.workspaces.model.DescribeIpGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsRequest,
      DescribeIpGroupsResponse
    ]("describeIpGroups", api.describeIpGroups)(request.buildAwsValue())
      .map(zio.aws.workspaces.model.DescribeIpGroupsResponse.wrap)
      .provideEnvironment(r)
    def createUpdatedWorkspaceImage(
        request: CreateUpdatedWorkspaceImageRequest
    ): IO[
      AwsError,
      zio.aws.workspaces.model.CreateUpdatedWorkspaceImageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageRequest,
      CreateUpdatedWorkspaceImageResponse
    ]("createUpdatedWorkspaceImage", api.createUpdatedWorkspaceImage)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.CreateUpdatedWorkspaceImageResponse.wrap)
      .provideEnvironment(r)
    def terminateWorkspaces(request: TerminateWorkspacesRequest): IO[
      AwsError,
      zio.aws.workspaces.model.TerminateWorkspacesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesRequest,
      TerminateWorkspacesResponse
    ]("terminateWorkspaces", api.terminateWorkspaces)(request.buildAwsValue())
      .map(zio.aws.workspaces.model.TerminateWorkspacesResponse.wrap)
      .provideEnvironment(r)
    def copyWorkspaceImage(request: CopyWorkspaceImageRequest): IO[
      AwsError,
      zio.aws.workspaces.model.CopyWorkspaceImageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageRequest,
      CopyWorkspaceImageResponse
    ]("copyWorkspaceImage", api.copyWorkspaceImage)(request.buildAwsValue())
      .map(zio.aws.workspaces.model.CopyWorkspaceImageResponse.wrap)
      .provideEnvironment(r)
    def associateConnectionAlias(request: AssociateConnectionAliasRequest): IO[
      AwsError,
      zio.aws.workspaces.model.AssociateConnectionAliasResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasRequest,
      AssociateConnectionAliasResponse
    ]("associateConnectionAlias", api.associateConnectionAlias)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.AssociateConnectionAliasResponse.wrap)
      .provideEnvironment(r)
    def rebuildWorkspaces(request: RebuildWorkspacesRequest): IO[
      AwsError,
      zio.aws.workspaces.model.RebuildWorkspacesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesRequest,
      RebuildWorkspacesResponse
    ]("rebuildWorkspaces", api.rebuildWorkspaces)(request.buildAwsValue())
      .map(zio.aws.workspaces.model.RebuildWorkspacesResponse.wrap)
      .provideEnvironment(r)
    def deleteTags(
        request: DeleteTagsRequest
    ): IO[AwsError, zio.aws.workspaces.model.DeleteTagsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.workspaces.model.DeleteTagsRequest,
        DeleteTagsResponse
      ]("deleteTags", api.deleteTags)(request.buildAwsValue())
        .map(zio.aws.workspaces.model.DeleteTagsResponse.wrap)
        .provideEnvironment(r)
    def describeWorkspaceImages(
        request: DescribeWorkspaceImagesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.workspaces.model.WorkspaceImage.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest,
      DescribeWorkspaceImagesResponse,
      WorkspaceImage
    ](
      "describeWorkspaceImages",
      api.describeWorkspaceImages,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.images().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.workspaces.model.WorkspaceImage.wrap(item))
      .provideEnvironment(r)
    def describeWorkspaceImagesPaginated(
        request: DescribeWorkspaceImagesRequest
    ): IO[
      AwsError,
      zio.aws.workspaces.model.DescribeWorkspaceImagesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest,
      DescribeWorkspaceImagesResponse
    ]("describeWorkspaceImages", api.describeWorkspaceImages)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.DescribeWorkspaceImagesResponse.wrap)
      .provideEnvironment(r)
    def createWorkspaces(request: CreateWorkspacesRequest): IO[
      AwsError,
      zio.aws.workspaces.model.CreateWorkspacesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.CreateWorkspacesRequest,
      CreateWorkspacesResponse
    ]("createWorkspaces", api.createWorkspaces)(request.buildAwsValue())
      .map(zio.aws.workspaces.model.CreateWorkspacesResponse.wrap)
      .provideEnvironment(r)
    def deleteWorkspaceImage(request: DeleteWorkspaceImageRequest): IO[
      AwsError,
      zio.aws.workspaces.model.DeleteWorkspaceImageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageRequest,
      DeleteWorkspaceImageResponse
    ]("deleteWorkspaceImage", api.deleteWorkspaceImage)(request.buildAwsValue())
      .map(zio.aws.workspaces.model.DeleteWorkspaceImageResponse.wrap)
      .provideEnvironment(r)
    def deleteConnectClientAddIn(request: DeleteConnectClientAddInRequest): IO[
      AwsError,
      zio.aws.workspaces.model.DeleteConnectClientAddInResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DeleteConnectClientAddInRequest,
      DeleteConnectClientAddInResponse
    ]("deleteConnectClientAddIn", api.deleteConnectClientAddIn)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.DeleteConnectClientAddInResponse.wrap)
      .provideEnvironment(r)
    def importClientBranding(request: ImportClientBrandingRequest): IO[
      AwsError,
      zio.aws.workspaces.model.ImportClientBrandingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.ImportClientBrandingRequest,
      ImportClientBrandingResponse
    ]("importClientBranding", api.importClientBranding)(request.buildAwsValue())
      .map(zio.aws.workspaces.model.ImportClientBrandingResponse.wrap)
      .provideEnvironment(r)
    def deleteWorkspaceBundle(request: DeleteWorkspaceBundleRequest): IO[
      AwsError,
      zio.aws.workspaces.model.DeleteWorkspaceBundleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceBundleRequest,
      DeleteWorkspaceBundleResponse
    ]("deleteWorkspaceBundle", api.deleteWorkspaceBundle)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.DeleteWorkspaceBundleResponse.wrap)
      .provideEnvironment(r)
    def describeConnectClientAddIns(
        request: DescribeConnectClientAddInsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.workspaces.model.ConnectClientAddIn.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsRequest,
      DescribeConnectClientAddInsResponse,
      ConnectClientAddIn
    ](
      "describeConnectClientAddIns",
      api.describeConnectClientAddIns,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.addIns().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.workspaces.model.ConnectClientAddIn.wrap(item))
      .provideEnvironment(r)
    def describeConnectClientAddInsPaginated(
        request: DescribeConnectClientAddInsRequest
    ): IO[
      AwsError,
      zio.aws.workspaces.model.DescribeConnectClientAddInsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsRequest,
      DescribeConnectClientAddInsResponse
    ]("describeConnectClientAddIns", api.describeConnectClientAddIns)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.DescribeConnectClientAddInsResponse.wrap)
      .provideEnvironment(r)
    def disassociateIpGroups(request: DisassociateIpGroupsRequest): IO[
      AwsError,
      zio.aws.workspaces.model.DisassociateIpGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsRequest,
      DisassociateIpGroupsResponse
    ]("disassociateIpGroups", api.disassociateIpGroups)(request.buildAwsValue())
      .map(zio.aws.workspaces.model.DisassociateIpGroupsResponse.wrap)
      .provideEnvironment(r)
    def describeClientProperties(request: DescribeClientPropertiesRequest): IO[
      AwsError,
      zio.aws.workspaces.model.DescribeClientPropertiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesRequest,
      DescribeClientPropertiesResponse
    ]("describeClientProperties", api.describeClientProperties)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.DescribeClientPropertiesResponse.wrap)
      .provideEnvironment(r)
    def updateConnectionAliasPermission(
        request: UpdateConnectionAliasPermissionRequest
    ): IO[
      AwsError,
      zio.aws.workspaces.model.UpdateConnectionAliasPermissionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspaces.model.UpdateConnectionAliasPermissionRequest,
      UpdateConnectionAliasPermissionResponse
    ]("updateConnectionAliasPermission", api.updateConnectionAliasPermission)(
      request.buildAwsValue()
    ).map(zio.aws.workspaces.model.UpdateConnectionAliasPermissionResponse.wrap)
      .provideEnvironment(r)
    def createTags(
        request: CreateTagsRequest
    ): IO[AwsError, zio.aws.workspaces.model.CreateTagsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.workspaces.model.CreateTagsRequest,
        CreateTagsResponse
      ]("createTags", api.createTags)(request.buildAwsValue())
        .map(zio.aws.workspaces.model.CreateTagsResponse.wrap)
        .provideEnvironment(r)
  }
  def modifyWorkspaceProperties(request: ModifyWorkspacePropertiesRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.ModifyWorkspacePropertiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyWorkspaceProperties(request))
  def describeTags(request: DescribeTagsRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DescribeTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTags(request))
  def updateRulesOfIpGroup(request: UpdateRulesOfIpGroupRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.UpdateRulesOfIpGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRulesOfIpGroup(request))
  def updateConnectClientAddIn(request: UpdateConnectClientAddInRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.UpdateConnectClientAddInResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateConnectClientAddIn(request))
  def deregisterWorkspaceDirectory(
      request: DeregisterWorkspaceDirectoryRequest
  ): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DeregisterWorkspaceDirectoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterWorkspaceDirectory(request))
  def deleteIpGroup(request: DeleteIpGroupRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DeleteIpGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteIpGroup(request))
  def deleteClientBranding(request: DeleteClientBrandingRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DeleteClientBrandingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteClientBranding(request))
  def describeConnectionAliases(
      request: DescribeConnectionAliasesRequest
  ): ZStream[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.ConnectionAlias.ReadOnly
  ] = ZStream.serviceWithStream(_.describeConnectionAliases(request))
  def describeConnectionAliasesPaginated(
      request: DescribeConnectionAliasesRequest
  ): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DescribeConnectionAliasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConnectionAliasesPaginated(request))
  def modifyAccount(request: ModifyAccountRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.ModifyAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyAccount(request))
  def describeAccountModifications(
      request: DescribeAccountModificationsRequest
  ): ZStream[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.AccountModification.ReadOnly
  ] = ZStream.serviceWithStream(_.describeAccountModifications(request))
  def describeAccountModificationsPaginated(
      request: DescribeAccountModificationsRequest
  ): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DescribeAccountModificationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccountModificationsPaginated(request))
  def describeWorkspaceBundles(
      request: DescribeWorkspaceBundlesRequest
  ): ZStream[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.WorkspaceBundle.ReadOnly
  ] = ZStream.serviceWithStream(_.describeWorkspaceBundles(request))
  def describeWorkspaceBundlesPaginated(
      request: DescribeWorkspaceBundlesRequest
  ): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DescribeWorkspaceBundlesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorkspaceBundlesPaginated(request))
  def startWorkspaces(request: StartWorkspacesRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.StartWorkspacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startWorkspaces(request))
  def describeClientBranding(request: DescribeClientBrandingRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DescribeClientBrandingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClientBranding(request))
  def modifySelfservicePermissions(
      request: ModifySelfservicePermissionsRequest
  ): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.ModifySelfservicePermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifySelfservicePermissions(request))
  def describeWorkspacesConnectionStatus(
      request: DescribeWorkspacesConnectionStatusRequest
  ): ZStream[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.WorkspaceConnectionStatus.ReadOnly
  ] = ZStream.serviceWithStream(_.describeWorkspacesConnectionStatus(request))
  def describeWorkspacesConnectionStatusPaginated(
      request: DescribeWorkspacesConnectionStatusRequest
  ): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DescribeWorkspacesConnectionStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorkspacesConnectionStatusPaginated(request))
  def modifyWorkspaceState(request: ModifyWorkspaceStateRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.ModifyWorkspaceStateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyWorkspaceState(request))
  def deleteConnectionAlias(request: DeleteConnectionAliasRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DeleteConnectionAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConnectionAlias(request))
  def modifyWorkspaceAccessProperties(
      request: ModifyWorkspaceAccessPropertiesRequest
  ): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.ModifyWorkspaceAccessPropertiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyWorkspaceAccessProperties(request))
  def createConnectionAlias(request: CreateConnectionAliasRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.CreateConnectionAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConnectionAlias(request))
  def revokeIpRules(request: RevokeIpRulesRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.RevokeIpRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.revokeIpRules(request))
  def restoreWorkspace(request: RestoreWorkspaceRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.RestoreWorkspaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreWorkspace(request))
  def describeConnectionAliasPermissions(
      request: DescribeConnectionAliasPermissionsRequest
  ): ZIO[zio.aws.workspaces.WorkSpaces, AwsError, StreamingOutputResult[
    Any,
    zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse.ReadOnly,
    zio.aws.workspaces.model.ConnectionAliasPermission.ReadOnly
  ]] = ZIO.serviceWithZIO(_.describeConnectionAliasPermissions(request))
  def describeConnectionAliasPermissionsPaginated(
      request: DescribeConnectionAliasPermissionsRequest
  ): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DescribeConnectionAliasPermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConnectionAliasPermissionsPaginated(request))
  def migrateWorkspace(request: MigrateWorkspaceRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.MigrateWorkspaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.migrateWorkspace(request))
  def updateWorkspaceImagePermission(
      request: UpdateWorkspaceImagePermissionRequest
  ): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.UpdateWorkspaceImagePermissionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWorkspaceImagePermission(request))
  def listAvailableManagementCidrRanges(
      request: ListAvailableManagementCidrRangesRequest
  ): ZStream[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    DedicatedTenancyManagementCidrRange
  ] = ZStream.serviceWithStream(_.listAvailableManagementCidrRanges(request))
  def listAvailableManagementCidrRangesPaginated(
      request: ListAvailableManagementCidrRangesRequest
  ): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.ListAvailableManagementCidrRangesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAvailableManagementCidrRangesPaginated(request))
  def authorizeIpRules(request: AuthorizeIpRulesRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.AuthorizeIpRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.authorizeIpRules(request))
  def describeWorkspaceImagePermissions(
      request: DescribeWorkspaceImagePermissionsRequest
  ): ZIO[zio.aws.workspaces.WorkSpaces, AwsError, StreamingOutputResult[
    Any,
    zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse.ReadOnly,
    zio.aws.workspaces.model.ImagePermission.ReadOnly
  ]] = ZIO.serviceWithZIO(_.describeWorkspaceImagePermissions(request))
  def describeWorkspaceImagePermissionsPaginated(
      request: DescribeWorkspaceImagePermissionsRequest
  ): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DescribeWorkspaceImagePermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorkspaceImagePermissionsPaginated(request))
  def describeAccount(request: DescribeAccountRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DescribeAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccount(request))
  def createIpGroup(request: CreateIpGroupRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.CreateIpGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createIpGroup(request))
  def updateWorkspaceBundle(request: UpdateWorkspaceBundleRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.UpdateWorkspaceBundleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWorkspaceBundle(request))
  def createWorkspaceBundle(request: CreateWorkspaceBundleRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.CreateWorkspaceBundleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorkspaceBundle(request))
  def importWorkspaceImage(request: ImportWorkspaceImageRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.ImportWorkspaceImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importWorkspaceImage(request))
  def registerWorkspaceDirectory(
      request: RegisterWorkspaceDirectoryRequest
  ): ZIO[zio.aws.workspaces.WorkSpaces, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.registerWorkspaceDirectory(request))
  def associateIpGroups(request: AssociateIpGroupsRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.AssociateIpGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateIpGroups(request))
  def createConnectClientAddIn(request: CreateConnectClientAddInRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.CreateConnectClientAddInResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConnectClientAddIn(request))
  def modifyClientProperties(request: ModifyClientPropertiesRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.ModifyClientPropertiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyClientProperties(request))
  def disassociateConnectionAlias(
      request: DisassociateConnectionAliasRequest
  ): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DisassociateConnectionAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateConnectionAlias(request))
  def stopWorkspaces(request: StopWorkspacesRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.StopWorkspacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopWorkspaces(request))
  def describeWorkspaces(request: DescribeWorkspacesRequest): ZStream[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.Workspace.ReadOnly
  ] = ZStream.serviceWithStream(_.describeWorkspaces(request))
  def describeWorkspacesPaginated(request: DescribeWorkspacesRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DescribeWorkspacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorkspacesPaginated(request))
  def rebootWorkspaces(request: RebootWorkspacesRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.RebootWorkspacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rebootWorkspaces(request))
  def describeWorkspaceDirectories(
      request: DescribeWorkspaceDirectoriesRequest
  ): ZStream[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.WorkspaceDirectory.ReadOnly
  ] = ZStream.serviceWithStream(_.describeWorkspaceDirectories(request))
  def describeWorkspaceDirectoriesPaginated(
      request: DescribeWorkspaceDirectoriesRequest
  ): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DescribeWorkspaceDirectoriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorkspaceDirectoriesPaginated(request))
  def modifyWorkspaceCreationProperties(
      request: ModifyWorkspaceCreationPropertiesRequest
  ): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.ModifyWorkspaceCreationPropertiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyWorkspaceCreationProperties(request))
  def describeWorkspaceSnapshots(
      request: DescribeWorkspaceSnapshotsRequest
  ): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DescribeWorkspaceSnapshotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorkspaceSnapshots(request))
  def describeIpGroups(request: DescribeIpGroupsRequest): ZStream[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.WorkspacesIpGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeIpGroups(request))
  def describeIpGroupsPaginated(request: DescribeIpGroupsRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DescribeIpGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeIpGroupsPaginated(request))
  def createUpdatedWorkspaceImage(
      request: CreateUpdatedWorkspaceImageRequest
  ): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.CreateUpdatedWorkspaceImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUpdatedWorkspaceImage(request))
  def terminateWorkspaces(request: TerminateWorkspacesRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.TerminateWorkspacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.terminateWorkspaces(request))
  def copyWorkspaceImage(request: CopyWorkspaceImageRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.CopyWorkspaceImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyWorkspaceImage(request))
  def associateConnectionAlias(request: AssociateConnectionAliasRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.AssociateConnectionAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateConnectionAlias(request))
  def rebuildWorkspaces(request: RebuildWorkspacesRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.RebuildWorkspacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rebuildWorkspaces(request))
  def deleteTags(request: DeleteTagsRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DeleteTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTags(request))
  def describeWorkspaceImages(request: DescribeWorkspaceImagesRequest): ZStream[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.WorkspaceImage.ReadOnly
  ] = ZStream.serviceWithStream(_.describeWorkspaceImages(request))
  def describeWorkspaceImagesPaginated(
      request: DescribeWorkspaceImagesRequest
  ): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DescribeWorkspaceImagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorkspaceImagesPaginated(request))
  def createWorkspaces(request: CreateWorkspacesRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.CreateWorkspacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorkspaces(request))
  def deleteWorkspaceImage(request: DeleteWorkspaceImageRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DeleteWorkspaceImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWorkspaceImage(request))
  def deleteConnectClientAddIn(request: DeleteConnectClientAddInRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DeleteConnectClientAddInResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConnectClientAddIn(request))
  def importClientBranding(request: ImportClientBrandingRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.ImportClientBrandingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importClientBranding(request))
  def deleteWorkspaceBundle(request: DeleteWorkspaceBundleRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DeleteWorkspaceBundleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWorkspaceBundle(request))
  def describeConnectClientAddIns(
      request: DescribeConnectClientAddInsRequest
  ): ZStream[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.ConnectClientAddIn.ReadOnly
  ] = ZStream.serviceWithStream(_.describeConnectClientAddIns(request))
  def describeConnectClientAddInsPaginated(
      request: DescribeConnectClientAddInsRequest
  ): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DescribeConnectClientAddInsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConnectClientAddInsPaginated(request))
  def disassociateIpGroups(request: DisassociateIpGroupsRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DisassociateIpGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateIpGroups(request))
  def describeClientProperties(request: DescribeClientPropertiesRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.DescribeClientPropertiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClientProperties(request))
  def updateConnectionAliasPermission(
      request: UpdateConnectionAliasPermissionRequest
  ): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.UpdateConnectionAliasPermissionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateConnectionAliasPermission(request))
  def createTags(request: CreateTagsRequest): ZIO[
    zio.aws.workspaces.WorkSpaces,
    AwsError,
    zio.aws.workspaces.model.CreateTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTags(request))
}
