package zio.aws.workspaces
import zio.aws.workspaces.model.primitives.{
  SubnetId,
  IpRule,
  DedicatedTenancyManagementCidrRange,
  WorkspaceId,
  IpGroupId,
  IpAddress,
  WorkspaceImageId,
  BundleId,
  DirectoryId,
  ConnectionAliasId,
  NonEmptyString
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.workspaces.model.primitives.PaginationToken.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object ARN extends Subtype[String]
    type ARN = zio.aws.workspaces.model.primitives.ARN.Type
    object AddInName extends Subtype[String]
    type AddInName = zio.aws.workspaces.model.primitives.AddInName.Type
    object AddInUrl extends Subtype[String]
    type AddInUrl = zio.aws.workspaces.model.primitives.AddInUrl.Type
    object Alias extends Subtype[String]
    type Alias = zio.aws.workspaces.model.primitives.Alias.Type
    object AmazonUuid extends Subtype[String]
    type AmazonUuid = zio.aws.workspaces.model.primitives.AmazonUuid.Type
    object AwsAccount extends Subtype[String]
    type AwsAccount = zio.aws.workspaces.model.primitives.AwsAccount.Type
    type BooleanObject = Boolean
    object BundleId extends Subtype[String]
    type BundleId = zio.aws.workspaces.model.primitives.BundleId.Type
    object BundleOwner extends Subtype[String]
    type BundleOwner = zio.aws.workspaces.model.primitives.BundleOwner.Type
    object ComputerName extends Subtype[String]
    type ComputerName = zio.aws.workspaces.model.primitives.ComputerName.Type
    object ConnectionAliasId extends Subtype[String]
    type ConnectionAliasId =
      zio.aws.workspaces.model.primitives.ConnectionAliasId.Type
    object ConnectionIdentifier extends Subtype[String]
    type ConnectionIdentifier =
      zio.aws.workspaces.model.primitives.ConnectionIdentifier.Type
    object ConnectionString extends Subtype[String]
    type ConnectionString =
      zio.aws.workspaces.model.primitives.ConnectionString.Type
    object DedicatedTenancyManagementCidrRange extends Subtype[String]
    type DedicatedTenancyManagementCidrRange =
      zio.aws.workspaces.model.primitives.DedicatedTenancyManagementCidrRange.Type
    object DefaultOu extends Subtype[String]
    type DefaultOu = zio.aws.workspaces.model.primitives.DefaultOu.Type
    object Description extends Subtype[String]
    type Description = zio.aws.workspaces.model.primitives.Description.Type
    object DirectoryId extends Subtype[String]
    type DirectoryId = zio.aws.workspaces.model.primitives.DirectoryId.Type
    object DirectoryName extends Subtype[String]
    type DirectoryName = zio.aws.workspaces.model.primitives.DirectoryName.Type
    object Ec2ImageId extends Subtype[String]
    type Ec2ImageId = zio.aws.workspaces.model.primitives.Ec2ImageId.Type
    object ErrorType extends Subtype[String]
    type ErrorType = zio.aws.workspaces.model.primitives.ErrorType.Type
    object IpAddress extends Subtype[String]
    type IpAddress = zio.aws.workspaces.model.primitives.IpAddress.Type
    object IpGroupDesc extends Subtype[String]
    type IpGroupDesc = zio.aws.workspaces.model.primitives.IpGroupDesc.Type
    object IpGroupId extends Subtype[String]
    type IpGroupId = zio.aws.workspaces.model.primitives.IpGroupId.Type
    object IpGroupName extends Subtype[String]
    type IpGroupName = zio.aws.workspaces.model.primitives.IpGroupName.Type
    object IpRule extends Subtype[String]
    type IpRule = zio.aws.workspaces.model.primitives.IpRule.Type
    object IpRuleDesc extends Subtype[String]
    type IpRuleDesc = zio.aws.workspaces.model.primitives.IpRuleDesc.Type
    object Limit extends Subtype[Int]
    type Limit = zio.aws.workspaces.model.primitives.Limit.Type
    object ManagementCidrRangeConstraint extends Subtype[String]
    type ManagementCidrRangeConstraint =
      zio.aws.workspaces.model.primitives.ManagementCidrRangeConstraint.Type
    object ManagementCidrRangeMaxResults extends Subtype[Int]
    type ManagementCidrRangeMaxResults =
      zio.aws.workspaces.model.primitives.ManagementCidrRangeMaxResults.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString =
      zio.aws.workspaces.model.primitives.NonEmptyString.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.workspaces.model.primitives.PaginationToken.Type
    object Region extends Subtype[String]
    type Region = zio.aws.workspaces.model.primitives.Region.Type
    object RegistrationCode extends Subtype[String]
    type RegistrationCode =
      zio.aws.workspaces.model.primitives.RegistrationCode.Type
    object RootVolumeSizeGib extends Subtype[Int]
    type RootVolumeSizeGib =
      zio.aws.workspaces.model.primitives.RootVolumeSizeGib.Type
    object RunningModeAutoStopTimeoutInMinutes extends Subtype[Int]
    type RunningModeAutoStopTimeoutInMinutes =
      zio.aws.workspaces.model.primitives.RunningModeAutoStopTimeoutInMinutes.Type
    object SecurityGroupId extends Subtype[String]
    type SecurityGroupId =
      zio.aws.workspaces.model.primitives.SecurityGroupId.Type
    object SubnetId extends Subtype[String]
    type SubnetId = zio.aws.workspaces.model.primitives.SubnetId.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.workspaces.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.workspaces.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.workspaces.model.primitives.Timestamp.Type
    object UpdateDescription extends Subtype[String]
    type UpdateDescription =
      zio.aws.workspaces.model.primitives.UpdateDescription.Type
    object UserName extends Subtype[String]
    type UserName = zio.aws.workspaces.model.primitives.UserName.Type
    object UserVolumeSizeGib extends Subtype[Int]
    type UserVolumeSizeGib =
      zio.aws.workspaces.model.primitives.UserVolumeSizeGib.Type
    object VolumeEncryptionKey extends Subtype[String]
    type VolumeEncryptionKey =
      zio.aws.workspaces.model.primitives.VolumeEncryptionKey.Type
    object WorkspaceBundleDescription extends Subtype[String]
    type WorkspaceBundleDescription =
      zio.aws.workspaces.model.primitives.WorkspaceBundleDescription.Type
    object WorkspaceBundleName extends Subtype[String]
    type WorkspaceBundleName =
      zio.aws.workspaces.model.primitives.WorkspaceBundleName.Type
    object WorkspaceErrorCode extends Subtype[String]
    type WorkspaceErrorCode =
      zio.aws.workspaces.model.primitives.WorkspaceErrorCode.Type
    object WorkspaceId extends Subtype[String]
    type WorkspaceId = zio.aws.workspaces.model.primitives.WorkspaceId.Type
    object WorkspaceImageDescription extends Subtype[String]
    type WorkspaceImageDescription =
      zio.aws.workspaces.model.primitives.WorkspaceImageDescription.Type
    object WorkspaceImageErrorCode extends Subtype[String]
    type WorkspaceImageErrorCode =
      zio.aws.workspaces.model.primitives.WorkspaceImageErrorCode.Type
    object WorkspaceImageId extends Subtype[String]
    type WorkspaceImageId =
      zio.aws.workspaces.model.primitives.WorkspaceImageId.Type
    object WorkspaceImageName extends Subtype[String]
    type WorkspaceImageName =
      zio.aws.workspaces.model.primitives.WorkspaceImageName.Type
  }
  type AccountModificationList =
    List[zio.aws.workspaces.model.AccountModification]
  type ApplicationList = List[zio.aws.workspaces.model.Application]
  type BundleIdList = List[BundleId]
  type BundleList = List[zio.aws.workspaces.model.WorkspaceBundle]
  type ClientPropertiesList =
    List[zio.aws.workspaces.model.ClientPropertiesResult]
  type ConnectClientAddInList =
    List[zio.aws.workspaces.model.ConnectClientAddIn]
  type ConnectionAliasAssociationList =
    List[zio.aws.workspaces.model.ConnectionAliasAssociation]
  type ConnectionAliasIdList = List[ConnectionAliasId]
  type ConnectionAliasList = List[zio.aws.workspaces.model.ConnectionAlias]
  type ConnectionAliasPermissions =
    List[zio.aws.workspaces.model.ConnectionAliasPermission]
  type DedicatedTenancyCidrRangeList = List[DedicatedTenancyManagementCidrRange]
  type DirectoryIdList = List[DirectoryId]
  type DirectoryList = List[zio.aws.workspaces.model.WorkspaceDirectory]
  type DnsIpAddresses = List[IpAddress]
  type FailedCreateWorkspaceRequests =
    List[zio.aws.workspaces.model.FailedCreateWorkspaceRequest]
  type FailedRebootWorkspaceRequests =
    List[zio.aws.workspaces.model.FailedWorkspaceChangeRequest]
  type FailedRebuildWorkspaceRequests =
    List[zio.aws.workspaces.model.FailedWorkspaceChangeRequest]
  type FailedStartWorkspaceRequests =
    List[zio.aws.workspaces.model.FailedWorkspaceChangeRequest]
  type FailedStopWorkspaceRequests =
    List[zio.aws.workspaces.model.FailedWorkspaceChangeRequest]
  type FailedTerminateWorkspaceRequests =
    List[zio.aws.workspaces.model.FailedWorkspaceChangeRequest]
  type ImagePermissions = List[zio.aws.workspaces.model.ImagePermission]
  type IpGroupIdList = List[IpGroupId]
  type IpRevokedRuleList = List[IpRule]
  type IpRuleList = List[zio.aws.workspaces.model.IpRuleItem]
  type ModificationStateList = List[zio.aws.workspaces.model.ModificationState]
  type RebootWorkspaceRequests = List[zio.aws.workspaces.model.RebootRequest]
  type RebuildWorkspaceRequests = List[zio.aws.workspaces.model.RebuildRequest]
  type ResourceIdList = List[NonEmptyString]
  type SnapshotList = List[zio.aws.workspaces.model.Snapshot]
  type StartWorkspaceRequests = List[zio.aws.workspaces.model.StartRequest]
  type StopWorkspaceRequests = List[zio.aws.workspaces.model.StopRequest]
  type SubnetIds = List[SubnetId]
  type TagKeyList = List[NonEmptyString]
  type TagList = List[zio.aws.workspaces.model.Tag]
  type TerminateWorkspaceRequests =
    List[zio.aws.workspaces.model.TerminateRequest]
  type WorkspaceConnectionStatusList =
    List[zio.aws.workspaces.model.WorkspaceConnectionStatus]
  type WorkspaceIdList = List[WorkspaceId]
  type WorkspaceImageIdList = List[WorkspaceImageId]
  type WorkspaceImageList = List[zio.aws.workspaces.model.WorkspaceImage]
  type WorkspaceList = List[zio.aws.workspaces.model.Workspace]
  type WorkspaceRequestList = List[zio.aws.workspaces.model.WorkspaceRequest]
  type WorkspacesIpGroupsList = List[zio.aws.workspaces.model.WorkspacesIpGroup]
}
