package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{IpGroupDesc, IpGroupName, IpGroupId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class WorkspacesIpGroup(
    groupId: Option[IpGroupId] = None,
    groupName: Option[IpGroupName] = None,
    groupDesc: Option[IpGroupDesc] = None,
    userRules: Option[Iterable[zio.aws.workspaces.model.IpRuleItem]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.WorkspacesIpGroup = {
    import WorkspacesIpGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.WorkspacesIpGroup
      .builder()
      .optionallyWith(
        groupId.map(value => IpGroupId.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(
        groupName.map(value => IpGroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        groupDesc.map(value => IpGroupDesc.unwrap(value): java.lang.String)
      )(_.groupDesc)
      .optionallyWith(
        userRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userRules)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.WorkspacesIpGroup.ReadOnly =
    zio.aws.workspaces.model.WorkspacesIpGroup.wrap(buildAwsValue())
}
object WorkspacesIpGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.WorkspacesIpGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.WorkspacesIpGroup =
      zio.aws.workspaces.model.WorkspacesIpGroup(
        groupId.map(value => value),
        groupName.map(value => value),
        groupDesc.map(value => value),
        userRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def groupId: Option[IpGroupId]
    def groupName: Option[IpGroupName]
    def groupDesc: Option[IpGroupDesc]
    def userRules: Option[List[zio.aws.workspaces.model.IpRuleItem.ReadOnly]]
    def getGroupId: ZIO[Any, AwsError, IpGroupId] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getGroupName: ZIO[Any, AwsError, IpGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroupDesc: ZIO[Any, AwsError, IpGroupDesc] =
      AwsError.unwrapOptionField("groupDesc", groupDesc)
    def getUserRules: ZIO[Any, AwsError, List[
      zio.aws.workspaces.model.IpRuleItem.ReadOnly
    ]] = AwsError.unwrapOptionField("userRules", userRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspacesIpGroup
  ) extends zio.aws.workspaces.model.WorkspacesIpGroup.ReadOnly {
    override val groupId: Option[IpGroupId] = scala
      .Option(impl.groupId())
      .map(value => zio.aws.workspaces.model.primitives.IpGroupId(value))
    override val groupName: Option[IpGroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.workspaces.model.primitives.IpGroupName(value))
    override val groupDesc: Option[IpGroupDesc] = scala
      .Option(impl.groupDesc())
      .map(value => zio.aws.workspaces.model.primitives.IpGroupDesc(value))
    override val userRules
        : Option[List[zio.aws.workspaces.model.IpRuleItem.ReadOnly]] = scala
      .Option(impl.userRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspaces.model.IpRuleItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspacesIpGroup
  ): zio.aws.workspaces.model.WorkspacesIpGroup.ReadOnly = new Wrapper(impl)
}
