package zio.aws.workspaces.model
import zio.aws.workspaces.model.primitives.{
  Timestamp,
  Description,
  BundleOwner,
  WorkspaceImageId,
  BundleId,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class WorkspaceBundle(
    bundleId: Option[BundleId] = None,
    name: Option[NonEmptyString] = None,
    owner: Option[BundleOwner] = None,
    description: Option[Description] = None,
    imageId: Option[WorkspaceImageId] = None,
    rootStorage: Option[zio.aws.workspaces.model.RootStorage] = None,
    userStorage: Option[zio.aws.workspaces.model.UserStorage] = None,
    computeType: Option[zio.aws.workspaces.model.ComputeType] = None,
    lastUpdatedTime: Option[Timestamp] = None,
    creationTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.WorkspaceBundle = {
    import WorkspaceBundle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.WorkspaceBundle
      .builder()
      .optionallyWith(
        bundleId.map(value => BundleId.unwrap(value): java.lang.String)
      )(_.bundleId)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        owner.map(value => BundleOwner.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        imageId.map(value => WorkspaceImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(rootStorage.map(value => value.buildAwsValue()))(
        _.rootStorage
      )
      .optionallyWith(userStorage.map(value => value.buildAwsValue()))(
        _.userStorage
      )
      .optionallyWith(computeType.map(value => value.buildAwsValue()))(
        _.computeType
      )
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.WorkspaceBundle.ReadOnly =
    zio.aws.workspaces.model.WorkspaceBundle.wrap(buildAwsValue())
}
object WorkspaceBundle {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.WorkspaceBundle
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.WorkspaceBundle =
      zio.aws.workspaces.model.WorkspaceBundle(
        bundleId.map(value => value),
        name.map(value => value),
        owner.map(value => value),
        description.map(value => value),
        imageId.map(value => value),
        rootStorage.map(value => value.asEditable),
        userStorage.map(value => value.asEditable),
        computeType.map(value => value.asEditable),
        lastUpdatedTime.map(value => value),
        creationTime.map(value => value)
      )
    def bundleId: Option[BundleId]
    def name: Option[NonEmptyString]
    def owner: Option[BundleOwner]
    def description: Option[Description]
    def imageId: Option[WorkspaceImageId]
    def rootStorage: Option[zio.aws.workspaces.model.RootStorage.ReadOnly]
    def userStorage: Option[zio.aws.workspaces.model.UserStorage.ReadOnly]
    def computeType: Option[zio.aws.workspaces.model.ComputeType.ReadOnly]
    def lastUpdatedTime: Option[Timestamp]
    def creationTime: Option[Timestamp]
    def getBundleId: ZIO[Any, AwsError, BundleId] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getOwner: ZIO[Any, AwsError, BundleOwner] =
      AwsError.unwrapOptionField("owner", owner)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getImageId: ZIO[Any, AwsError, WorkspaceImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getRootStorage
        : ZIO[Any, AwsError, zio.aws.workspaces.model.RootStorage.ReadOnly] =
      AwsError.unwrapOptionField("rootStorage", rootStorage)
    def getUserStorage
        : ZIO[Any, AwsError, zio.aws.workspaces.model.UserStorage.ReadOnly] =
      AwsError.unwrapOptionField("userStorage", userStorage)
    def getComputeType
        : ZIO[Any, AwsError, zio.aws.workspaces.model.ComputeType.ReadOnly] =
      AwsError.unwrapOptionField("computeType", computeType)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceBundle
  ) extends zio.aws.workspaces.model.WorkspaceBundle.ReadOnly {
    override val bundleId: Option[BundleId] = scala
      .Option(impl.bundleId())
      .map(value => zio.aws.workspaces.model.primitives.BundleId(value))
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.workspaces.model.primitives.NonEmptyString(value))
    override val owner: Option[BundleOwner] = scala
      .Option(impl.owner())
      .map(value => zio.aws.workspaces.model.primitives.BundleOwner(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.workspaces.model.primitives.Description(value))
    override val imageId: Option[WorkspaceImageId] = scala
      .Option(impl.imageId())
      .map(value => zio.aws.workspaces.model.primitives.WorkspaceImageId(value))
    override val rootStorage
        : Option[zio.aws.workspaces.model.RootStorage.ReadOnly] = scala
      .Option(impl.rootStorage())
      .map(value => zio.aws.workspaces.model.RootStorage.wrap(value))
    override val userStorage
        : Option[zio.aws.workspaces.model.UserStorage.ReadOnly] = scala
      .Option(impl.userStorage())
      .map(value => zio.aws.workspaces.model.UserStorage.wrap(value))
    override val computeType
        : Option[zio.aws.workspaces.model.ComputeType.ReadOnly] = scala
      .Option(impl.computeType())
      .map(value => zio.aws.workspaces.model.ComputeType.wrap(value))
    override val lastUpdatedTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedTime())
      .map(value => zio.aws.workspaces.model.primitives.Timestamp(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.workspaces.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceBundle
  ): zio.aws.workspaces.model.WorkspaceBundle.ReadOnly = new Wrapper(impl)
}
