package zio.aws.workspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class WorkspaceAccessProperties(
    deviceTypeWindows: Option[zio.aws.workspaces.model.AccessPropertyValue] =
      None,
    deviceTypeOsx: Option[zio.aws.workspaces.model.AccessPropertyValue] = None,
    deviceTypeWeb: Option[zio.aws.workspaces.model.AccessPropertyValue] = None,
    deviceTypeIos: Option[zio.aws.workspaces.model.AccessPropertyValue] = None,
    deviceTypeAndroid: Option[zio.aws.workspaces.model.AccessPropertyValue] =
      None,
    deviceTypeChromeOs: Option[zio.aws.workspaces.model.AccessPropertyValue] =
      None,
    deviceTypeZeroClient: Option[zio.aws.workspaces.model.AccessPropertyValue] =
      None,
    deviceTypeLinux: Option[zio.aws.workspaces.model.AccessPropertyValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspaces.model.WorkspaceAccessProperties = {
    import WorkspaceAccessProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspaces.model.WorkspaceAccessProperties
      .builder()
      .optionallyWith(deviceTypeWindows.map(value => value.unwrap))(
        _.deviceTypeWindows
      )
      .optionallyWith(deviceTypeOsx.map(value => value.unwrap))(_.deviceTypeOsx)
      .optionallyWith(deviceTypeWeb.map(value => value.unwrap))(_.deviceTypeWeb)
      .optionallyWith(deviceTypeIos.map(value => value.unwrap))(_.deviceTypeIos)
      .optionallyWith(deviceTypeAndroid.map(value => value.unwrap))(
        _.deviceTypeAndroid
      )
      .optionallyWith(deviceTypeChromeOs.map(value => value.unwrap))(
        _.deviceTypeChromeOs
      )
      .optionallyWith(deviceTypeZeroClient.map(value => value.unwrap))(
        _.deviceTypeZeroClient
      )
      .optionallyWith(deviceTypeLinux.map(value => value.unwrap))(
        _.deviceTypeLinux
      )
      .build()
  }
  def asReadOnly: zio.aws.workspaces.model.WorkspaceAccessProperties.ReadOnly =
    zio.aws.workspaces.model.WorkspaceAccessProperties.wrap(buildAwsValue())
}
object WorkspaceAccessProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspaces.model.WorkspaceAccessProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspaces.model.WorkspaceAccessProperties =
      zio.aws.workspaces.model.WorkspaceAccessProperties(
        deviceTypeWindows.map(value => value),
        deviceTypeOsx.map(value => value),
        deviceTypeWeb.map(value => value),
        deviceTypeIos.map(value => value),
        deviceTypeAndroid.map(value => value),
        deviceTypeChromeOs.map(value => value),
        deviceTypeZeroClient.map(value => value),
        deviceTypeLinux.map(value => value)
      )
    def deviceTypeWindows: Option[zio.aws.workspaces.model.AccessPropertyValue]
    def deviceTypeOsx: Option[zio.aws.workspaces.model.AccessPropertyValue]
    def deviceTypeWeb: Option[zio.aws.workspaces.model.AccessPropertyValue]
    def deviceTypeIos: Option[zio.aws.workspaces.model.AccessPropertyValue]
    def deviceTypeAndroid: Option[zio.aws.workspaces.model.AccessPropertyValue]
    def deviceTypeChromeOs: Option[zio.aws.workspaces.model.AccessPropertyValue]
    def deviceTypeZeroClient
        : Option[zio.aws.workspaces.model.AccessPropertyValue]
    def deviceTypeLinux: Option[zio.aws.workspaces.model.AccessPropertyValue]
    def getDeviceTypeWindows
        : ZIO[Any, AwsError, zio.aws.workspaces.model.AccessPropertyValue] =
      AwsError.unwrapOptionField("deviceTypeWindows", deviceTypeWindows)
    def getDeviceTypeOsx
        : ZIO[Any, AwsError, zio.aws.workspaces.model.AccessPropertyValue] =
      AwsError.unwrapOptionField("deviceTypeOsx", deviceTypeOsx)
    def getDeviceTypeWeb
        : ZIO[Any, AwsError, zio.aws.workspaces.model.AccessPropertyValue] =
      AwsError.unwrapOptionField("deviceTypeWeb", deviceTypeWeb)
    def getDeviceTypeIos
        : ZIO[Any, AwsError, zio.aws.workspaces.model.AccessPropertyValue] =
      AwsError.unwrapOptionField("deviceTypeIos", deviceTypeIos)
    def getDeviceTypeAndroid
        : ZIO[Any, AwsError, zio.aws.workspaces.model.AccessPropertyValue] =
      AwsError.unwrapOptionField("deviceTypeAndroid", deviceTypeAndroid)
    def getDeviceTypeChromeOs
        : ZIO[Any, AwsError, zio.aws.workspaces.model.AccessPropertyValue] =
      AwsError.unwrapOptionField("deviceTypeChromeOs", deviceTypeChromeOs)
    def getDeviceTypeZeroClient
        : ZIO[Any, AwsError, zio.aws.workspaces.model.AccessPropertyValue] =
      AwsError.unwrapOptionField("deviceTypeZeroClient", deviceTypeZeroClient)
    def getDeviceTypeLinux
        : ZIO[Any, AwsError, zio.aws.workspaces.model.AccessPropertyValue] =
      AwsError.unwrapOptionField("deviceTypeLinux", deviceTypeLinux)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceAccessProperties
  ) extends zio.aws.workspaces.model.WorkspaceAccessProperties.ReadOnly {
    override val deviceTypeWindows
        : Option[zio.aws.workspaces.model.AccessPropertyValue] = scala
      .Option(impl.deviceTypeWindows())
      .map(value => zio.aws.workspaces.model.AccessPropertyValue.wrap(value))
    override val deviceTypeOsx
        : Option[zio.aws.workspaces.model.AccessPropertyValue] = scala
      .Option(impl.deviceTypeOsx())
      .map(value => zio.aws.workspaces.model.AccessPropertyValue.wrap(value))
    override val deviceTypeWeb
        : Option[zio.aws.workspaces.model.AccessPropertyValue] = scala
      .Option(impl.deviceTypeWeb())
      .map(value => zio.aws.workspaces.model.AccessPropertyValue.wrap(value))
    override val deviceTypeIos
        : Option[zio.aws.workspaces.model.AccessPropertyValue] = scala
      .Option(impl.deviceTypeIos())
      .map(value => zio.aws.workspaces.model.AccessPropertyValue.wrap(value))
    override val deviceTypeAndroid
        : Option[zio.aws.workspaces.model.AccessPropertyValue] = scala
      .Option(impl.deviceTypeAndroid())
      .map(value => zio.aws.workspaces.model.AccessPropertyValue.wrap(value))
    override val deviceTypeChromeOs
        : Option[zio.aws.workspaces.model.AccessPropertyValue] = scala
      .Option(impl.deviceTypeChromeOs())
      .map(value => zio.aws.workspaces.model.AccessPropertyValue.wrap(value))
    override val deviceTypeZeroClient
        : Option[zio.aws.workspaces.model.AccessPropertyValue] = scala
      .Option(impl.deviceTypeZeroClient())
      .map(value => zio.aws.workspaces.model.AccessPropertyValue.wrap(value))
    override val deviceTypeLinux
        : Option[zio.aws.workspaces.model.AccessPropertyValue] = scala
      .Option(impl.deviceTypeLinux())
      .map(value => zio.aws.workspaces.model.AccessPropertyValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspaces.model.WorkspaceAccessProperties
  ): zio.aws.workspaces.model.WorkspaceAccessProperties.ReadOnly = new Wrapper(
    impl
  )
}
